/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import org.eclipse.xtext.util.Strings;

public class ExtensionFactoryUtil {
    protected static final String EXECUTABLE_EXTENSION_FACTORY = "ExecutableExtensionFactory";

    public static NameAndClass parseExtensionFactory(String factAndClass) {
        if (factAndClass == null) {
            return new NameAndClass(null, null);
        }
        String[] segs = factAndClass.split(":");
        if (segs.length == 2) {
            String fact = segs[0];
            String clazz = segs[1];
            if (fact.endsWith(EXECUTABLE_EXTENSION_FACTORY)) {
                return new NameAndClass(fact.substring(0, fact.length() - EXECUTABLE_EXTENSION_FACTORY.length()), clazz);
            }
            return new NameAndClass(null, clazz);
        }
        return new NameAndClass(null, factAndClass);
    }

    public static class NameAndClass {
        private final String uiLangName;
        private final String clazz;

        public NameAndClass(String uiLangName, String clazz) {
            this.uiLangName = uiLangName;
            this.clazz = clazz;
        }

        public String getUiLangName() {
            return this.uiLangName;
        }

        public String getClazz() {
            return this.clazz;
        }

        public boolean hasNameAndClass() {
            return !Strings.isEmpty((String)this.clazz) && !Strings.isEmpty((String)this.uiLangName);
        }
    }
}

