/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import org.eclipse.e4.ui.internal.workbench.swt.AnimationEngine;
import org.eclipse.swt.widgets.Shell;

public abstract class AnimationFeedbackBase {
    private AnimationEngine engine;
    private Shell baseShell;
    private Shell animationShell = null;

    public AnimationFeedbackBase(Shell parentShell) {
        this.baseShell = parentShell;
        this.baseShell.addDisposeListener(e -> {
            if (this.engine != null) {
                this.engine.cancelAnimation();
            }
        });
    }

    public abstract void initialize(AnimationEngine var1);

    public abstract void renderStep(AnimationEngine var1);

    public boolean jobInit(AnimationEngine engine) {
        this.engine = engine;
        return engine != null;
    }

    public void dispose() {
        if (this.animationShell != null && !this.animationShell.isDisposed()) {
            this.animationShell.dispose();
        }
    }

    public Shell getBaseShell() {
        return this.baseShell;
    }

    public Shell getAnimationShell() {
        if (this.animationShell == null) {
            this.animationShell = new Shell(this.getBaseShell(), 16392);
            this.animationShell.addDisposeListener(e -> {
                if (this.engine != null) {
                    this.engine.cancelAnimation();
                }
            });
        }
        return this.animationShell;
    }
}

