/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor.hyperlinking.packagejson;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.n4js.json.JSON.JSONPackage;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.ui.editor.hyperlinking.IJSONHyperlinkHelperExtension;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.resource.XpectAwareFileExtensionCalculator;
import org.eclipse.n4js.ui.external.EclipseExternalLibraryWorkspace;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.XtextHyperlink;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class PackageJsonHyperlinkHelperExtension
implements IJSONHyperlinkHelperExtension {
    @Inject
    private IN4JSCore model;
    @Inject
    private EclipseExternalLibraryWorkspace extWS;
    @Inject
    private Provider<XtextHyperlink> hyperlinkProvider;
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private XpectAwareFileExtensionCalculator fileExtensionCalculator;

    public boolean isResponsible(XtextResource resource) {
        return this.fileExtensionCalculator.getFilenameWithoutXpectExtension(resource.getURI()).equals("package.json");
    }

    public IHyperlink[] getHyperlinks(XtextResource resource, int offset) {
        EObject eObject = this.eObjectAtOffsetHelper.resolveElementAt(resource, offset);
        Pair<SafeURI<?>, Region> linkedProjectWithRegion = this.getUriRegionPair(eObject);
        if (linkedProjectWithRegion != null) {
            URI uri = ((SafeURI)linkedProjectWithRegion.getFirst()).toURI();
            IRegion region = (IRegion)linkedProjectWithRegion.getSecond();
            IN4JSProject uriProject = (IN4JSProject)this.model.findProject(uri).orNull();
            String lnkName = uriProject == null ? ProjectDescriptionUtils.deriveN4JSProjectNameFromURI((URI)uri) : uriProject.getProjectName().getRawName();
            XtextHyperlink hyperlink = (XtextHyperlink)this.hyperlinkProvider.get();
            hyperlink.setHyperlinkRegion(region);
            hyperlink.setURI(uri);
            hyperlink.setHyperlinkText(lnkName);
            return new IHyperlink[]{hyperlink};
        }
        return null;
    }

    private Pair<SafeURI<?>, Region> getUriRegionPair(EObject eObject) {
        PackageJsonProperties nearestKnownPJP = this.findNearestKnownPJP(eObject);
        if (nearestKnownPJP == null) {
            return null;
        }
        switch (nearestKnownPJP) {
            case MAIN: {
                if (eObject instanceof NameValuePair) {
                    eObject = ((NameValuePair)eObject).getValue();
                }
                if (!(eObject instanceof JSONStringLiteral)) break;
                return this.hyperlinkToMain((JSONStringLiteral)eObject);
            }
            case MAIN_MODULE: {
                if (eObject instanceof NameValuePair) {
                    eObject = ((NameValuePair)eObject).getValue();
                }
                if (!(eObject instanceof JSONStringLiteral)) break;
                return this.hyperlinkToMainModule((JSONStringLiteral)eObject);
            }
            case REQUIRED_RUNTIME_LIBRARIES: {
                if (eObject instanceof NameValuePair) {
                    eObject = ((NameValuePair)eObject).getValue();
                }
                if (!(eObject instanceof JSONStringLiteral)) break;
                return this.hyperlinkToRequiredRTLibs((JSONStringLiteral)eObject);
            }
            case DEFINES_PACKAGE: {
                EObject parent1;
                EObject eObject2 = parent1 = eObject == null ? null : eObject.eContainer();
                if (!(parent1 instanceof NameValuePair)) break;
                NameValuePair nvpDependency = (NameValuePair)parent1;
                return this.hyperlinkToDependencySection(nvpDependency);
            }
            case DEPENDENCIES: 
            case DEV_DEPENDENCIES: {
                if (!(eObject instanceof NameValuePair)) break;
                NameValuePair nvpDependency = (NameValuePair)eObject;
                return this.hyperlinkToProjectProperty(nvpDependency);
            }
        }
        return null;
    }

    private Pair<SafeURI<?>, Region> hyperlinkToMain(JSONStringLiteral mainModuleJsonLiteral) {
        String mainPath = mainModuleJsonLiteral.getValue();
        if (!Strings.isNullOrEmpty((String)mainPath)) {
            URI packageJsonLoc = mainModuleJsonLiteral.eResource().getURI();
            IN4JSProject project = (IN4JSProject)this.model.findProject(packageJsonLoc).orNull();
            ICompositeNode node = NodeModelUtils.getNode((EObject)mainModuleJsonLiteral);
            if (project != null && node != null) {
                Region region = new Region(node.getOffset() + 1, node.getLength() - 2);
                SafeURI mainResolvedPath = project.getLocation().resolve(mainPath);
                if (mainResolvedPath.exists()) {
                    return Tuples.pair((Object)mainResolvedPath, (Object)region);
                }
            }
        }
        return null;
    }

    private Pair<SafeURI<?>, Region> hyperlinkToMainModule(JSONStringLiteral mainModuleJsonLiteral) {
        String mainModule = mainModuleJsonLiteral.getValue();
        if (!Strings.isNullOrEmpty((String)mainModule)) {
            URI packageJsonLoc = mainModuleJsonLiteral.eResource().getURI();
            IN4JSProject project = (IN4JSProject)this.model.findProject(packageJsonLoc).orNull();
            ICompositeNode node = NodeModelUtils.getNode((EObject)mainModuleJsonLiteral);
            if (project != null && node != null) {
                Region region = new Region(node.getOffset() + 1, node.getLength() - 2);
                for (IN4JSSourceContainer sc : project.getSourceContainers()) {
                    QualifiedName qualifiedName;
                    SafeURI mainModuleURI = sc.findArtifact(qualifiedName = QualifiedName.create((String)mainModule), Optional.of((Object)"n4js"));
                    if (mainModuleURI == null) {
                        mainModuleURI = sc.findArtifact(qualifiedName, Optional.of((Object)"n4jsx"));
                    }
                    if (mainModuleURI == null) continue;
                    return Tuples.pair((Object)mainModuleURI, (Object)region);
                }
            }
        }
        return null;
    }

    private Pair<SafeURI<?>, Region> hyperlinkToRequiredRTLibs(JSONStringLiteral mainModuleJsonLiteral) {
        String projectName = mainModuleJsonLiteral.getValue();
        if (!Strings.isNullOrEmpty((String)projectName)) {
            SafeURI<?> pdu = this.getProjectDescriptionLocationForName(new N4JSProjectName(projectName));
            ICompositeNode node = NodeModelUtils.getNode((EObject)mainModuleJsonLiteral);
            if (pdu != null && node != null) {
                Region region = new Region(node.getOffset() + 1, node.getLength() - 2);
                return Tuples.pair(pdu, (Object)region);
            }
        }
        return null;
    }

    private Pair<SafeURI<?>, Region> hyperlinkToProjectProperty(NameValuePair nvpDependency) {
        List node;
        String projectName = nvpDependency.getName();
        SafeURI<?> pdu = this.getProjectDescriptionLocationForName(new N4JSProjectName(projectName));
        if (pdu != null && !(node = NodeModelUtils.findNodesForFeature((EObject)nvpDependency, (EStructuralFeature)JSONPackage.Literals.NAME_VALUE_PAIR__NAME)).isEmpty()) {
            INode nameNode = (INode)node.get(0);
            Region region = new Region(nameNode.getOffset() + 1, nameNode.getLength() - 2);
            return Tuples.pair(pdu, (Object)region);
        }
        return null;
    }

    private Pair<SafeURI<?>, Region> hyperlinkToDependencySection(NameValuePair projectNameInValue) {
        JSONStringLiteral jsonValue = (JSONStringLiteral)projectNameInValue.getValue();
        String projectName = jsonValue.getValue();
        SafeURI<?> pdu = this.getProjectDescriptionLocationForName(new N4JSProjectName(projectName));
        if (pdu != null) {
            ICompositeNode valueNode = NodeModelUtils.getNode((EObject)jsonValue);
            Region region = new Region(valueNode.getOffset() + 1, valueNode.getLength() - 2);
            return Tuples.pair(pdu, (Object)region);
        }
        return null;
    }

    private SafeURI<?> getProjectDescriptionLocationForName(N4JSProjectName projectName) {
        IN4JSProject project = (IN4JSProject)this.model.findAllProjectMappings().get(projectName);
        SafeURI rootLocation = null;
        if (project == null) {
            for (Pair<FileURI, ProjectDescription> pair : this.extWS.getProjectsIncludingUnnecessary()) {
                String name = ((ProjectDescription)pair.getSecond()).getProjectName();
                if (!Objects.equal((Object)projectName, (Object)name)) continue;
                rootLocation = (SafeURI)pair.getFirst();
            }
        } else {
            rootLocation = project.getLocation();
        }
        if (rootLocation != null) {
            SafeURI pckjsonUri = rootLocation.appendSegment("package.json");
            return pckjsonUri;
        }
        return null;
    }

    private PackageJsonProperties findNearestKnownPJP(EObject eObject) {
        EObject tmpObj = eObject;
        while (tmpObj != null) {
            String name;
            PackageJsonProperties pjp;
            if (tmpObj instanceof NameValuePair && (pjp = PackageJsonProperties.valueOfNameOrNull((String)(name = ((NameValuePair)tmpObj).getName()))) != null) {
                return pjp;
            }
            tmpObj = tmpObj.eContainer();
        }
        return null;
    }
}

