/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorUtils {
    private static final Map<RGB, Color> colors = new HashMap<RGB, Color>();

    public static Color getColor(RGB rgb) {
        if (!colors.containsKey(rgb)) {
            colors.put(new RGB(rgb.red, rgb.green, rgb.blue), new Color((Device)Display.getCurrent(), rgb.red, rgb.green, rgb.blue));
        }
        return colors.get(rgb);
    }

    public static int clamp(float channel) {
        int v = (int)channel;
        if (v < 0) {
            return 0;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }

    public static Color darken(RGB color, float factor) {
        factor = (float)Math.cbrt(factor);
        int dr = ColorUtils.clamp((float)color.red * factor);
        int dg = ColorUtils.clamp((float)color.green * factor);
        int db = ColorUtils.clamp((float)color.blue * factor);
        return ColorUtils.getColor(dr, dg, db);
    }

    private static Color getColor(int red, int green, int blue) {
        return ColorUtils.getColor(new RGB(red, green, blue));
    }
}

