/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.validation;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONPackage;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.extension.JSONExtensionRegistry;
import org.eclipse.n4js.json.services.JSONGrammarAccess;
import org.eclipse.n4js.json.validation.AbstractJSONValidator;
import org.eclipse.n4js.json.validation.JSONIssueCodes;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;

public class JSONValidator
extends AbstractJSONValidator {
    @Inject
    private JSONGrammarAccess grammarAccess;
    @Inject
    private JSONExtensionRegistry validatorExtensionRegistry;

    JSONValidator() {
    }

    @Check
    public void checkUsingValidatorExtensions(JSONDocument document) {
        this.validatorExtensionRegistry.getValidatorExtensions().forEach(validatorExtension -> validatorExtension.validateJSON(document, this.getChain()));
    }

    @Check
    public void checkDuplicateKeys(JSONObject object) {
        HashMap<String, JSONValue> values = new HashMap<String, JSONValue>();
        for (NameValuePair pair : object.getNameValuePairs()) {
            JSONValue value = (JSONValue)values.get(pair.getName());
            if (value != null) {
                ICompositeNode duplicatedNode = NodeModelUtils.findActualNodeFor((EObject)value);
                int duplicatedLine = NodeModelUtils.getLineAndColumn((INode)duplicatedNode, (int)duplicatedNode.getOffset()).getLine();
                this.addIssue(JSONIssueCodes.getMessageForJSON_DUPLICATE_KEY(pair.getName(), duplicatedLine), (EObject)pair, (EStructuralFeature)JSONPackage.Literals.NAME_VALUE_PAIR__NAME, "JSON_DUPLICATE_KEY", new String[0]);
            }
            values.put(pair.getName(), pair.getValue());
        }
    }

    @Check
    public void checkDocumentForComments(JSONDocument document) {
        ICompositeNode documentNode = NodeModelUtils.findActualNodeFor((EObject)document);
        ICompositeNode rootNode = documentNode.getRootNode();
        StreamSupport.stream(rootNode.getAsTreeIterable().spliterator(), false).filter(n -> n instanceof HiddenLeafNode).filter(n -> this.isCommentNode((INode)n)).forEach(n -> this.addIssue(JSONIssueCodes.getMessageForJSON_COMMENT_UNSUPPORTED(), (EObject)document, n.getOffset(), n.getLength(), "JSON_COMMENT_UNSUPPORTED"));
    }

    private boolean isCommentNode(INode node) {
        EObject grammarElement = node.getGrammarElement();
        if (grammarElement instanceof TerminalRule) {
            return ((TerminalRule)grammarElement).getName().equals(this.grammarAccess.getSL_COMMENTRule().getName()) || ((TerminalRule)grammarElement).getName().equals(this.grammarAccess.getML_COMMENTRule().getName());
        }
        return false;
    }
}

