/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;

public class TypeDefinitionsAwareDependenciesSupplier {
    public static Iterable<IN4JSProject> get(IN4JSProject project) {
        ImmutableList<? extends IN4JSProject> dependencies = project.getDependencies();
        HashMap typeDefinitionsById = new HashMap();
        LinkedList<IN4JSProject> runtimeDependencies = new LinkedList<IN4JSProject>();
        HashSet<IN4JSProject> unusedTypeDefinitionProjects = new HashSet<IN4JSProject>();
        for (IN4JSProject dependency : dependencies) {
            if (dependency.getProjectType() == ProjectType.DEFINITION) {
                N4JSProjectName definesPackage = dependency.getDefinesPackageName();
                if (definesPackage != null) {
                    List typeDefinitionsProjects = typeDefinitionsById.getOrDefault(definesPackage, new ArrayList());
                    typeDefinitionsProjects.add(dependency);
                    typeDefinitionsById.put(definesPackage, typeDefinitionsProjects);
                }
                unusedTypeDefinitionProjects.add(dependency);
                continue;
            }
            runtimeDependencies.add(dependency);
        }
        LinkedList<IN4JSProject> orderedDependencies = new LinkedList<IN4JSProject>();
        for (IN4JSProject dependency : runtimeDependencies) {
            N4JSProjectName projectName = dependency.getProjectName();
            Collection typeDefinitionProjects = typeDefinitionsById.getOrDefault(projectName, Collections.emptyList());
            for (IN4JSProject typeDefinitionProject : typeDefinitionProjects) {
                if (!unusedTypeDefinitionProjects.contains(typeDefinitionProject)) continue;
                orderedDependencies.add(typeDefinitionProject);
                unusedTypeDefinitionProjects.remove(typeDefinitionProject);
            }
            orderedDependencies.add(dependency);
        }
        orderedDependencies.addAll(unusedTypeDefinitionProjects);
        if (orderedDependencies.size() != dependencies.size()) {
            throw new IllegalStateException("Failed to compute dependency order for project " + project.getLocation() + ": Ordered list of dependencies does not match original dependencies list in length.\n" + "Length " + orderedDependencies.size() + ": " + ((Object)orderedDependencies).toString() + " vs. " + "Length " + dependencies.size() + ": " + dependencies.toString());
        }
        return orderedDependencies;
    }
}

