/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.runner.helper;

import com.google.inject.Injector;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Scanner;
import org.eclipse.n4js.binaries.nodejs.NodeJsBinary;
import org.eclipse.n4js.cli.runner.helper.NodejsResult;
import org.eclipse.n4js.cli.runner.helper.NodejsRunner;
import org.eclipse.n4js.runner.RunConfiguration;

public class NodejsExecuter {
    private final NodejsRunner runner;

    public NodejsExecuter(Injector injector) {
        NodeJsBinary nodeJsBinary = (NodeJsBinary)injector.getInstance(NodeJsBinary.class);
        this.runner = new NodejsRunner(nodeJsBinary);
    }

    public NodejsResult run(Path workingDir, Path runFile) {
        NodejsResult result = new NodejsResult();
        RunConfiguration config = new RunConfiguration();
        config.setWorkingDirectory(workingDir);
        config.setFileToRun(runFile);
        try {
            Process process = this.runner.run(config);
            result.exitCode = process.waitFor();
            result.stdOut = this.getInputAsString(process.getInputStream());
            result.errOut = this.getInputAsString(process.getErrorStream());
        }
        catch (Exception e) {
            result.exception = e;
        }
        return result;
    }

    private String getInputAsString(InputStream is) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scanner = new Scanner(is);){
            String string = scanner.useDelimiter("\\A").hasNext() ? scanner.next() : "";
            return string.trim();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

