/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.projectModel.locations;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;

public final class PlatformResourceURI
extends SafeURI<PlatformResourceURI> {
    private IResource cachedResource;

    public PlatformResourceURI(URI location) {
        super(location);
    }

    public PlatformResourceURI(IResource resource) {
        super(URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true));
        this.cachedResource = resource;
    }

    @Override
    protected URI validate(URI given) throws IllegalArgumentException, NullPointerException {
        super.validate(given);
        Preconditions.checkArgument((boolean)given.isPlatformResource(), (String)"%s", (Object)given);
        Preconditions.checkArgument((given.segmentCount() >= 2 ? 1 : 0) != 0, (String)"%s", (Object)given);
        return given;
    }

    private IResource getCachedResource() {
        if (this.cachedResource != null) {
            return this.cachedResource;
        }
        this.cachedResource = ResourcesPlugin.getWorkspace().getRoot().findMember(this.toURI().toPlatformString(true));
        return this.cachedResource;
    }

    @Override
    public boolean isFile() {
        IResource r = this.getCachedResource();
        if (r == null) {
            return false;
        }
        return r.getType() == 1;
    }

    @Override
    public String getName() {
        return this.toURI().lastSegment();
    }

    @Override
    public boolean exists() {
        IResource r = this.getCachedResource();
        return r != null && r.exists();
    }

    @Override
    public boolean isDirectory() {
        IResource r = this.getCachedResource();
        if (r == null) {
            return false;
        }
        int type = r.getType();
        return type == 2 || type == 4;
    }

    @Override
    public Iterable<? extends PlatformResourceURI> getChildren() {
        IResource resource = this.getCachedResource();
        if (resource instanceof IContainer) {
            try {
                Object[] children = ((IContainer)resource).members();
                return FluentIterable.from((Object[])children).transform(PlatformResourceURI::new);
            }
            catch (CoreException e) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public InputStream getContents() throws IOException {
        IResource resource = this.getCachedResource();
        if (resource instanceof IFile) {
            try {
                return ((IFile)resource).getContents();
            }
            catch (CoreException e) {
                throw new IOException(e);
            }
        }
        return null;
    }

    @Override
    public String getAbsolutePath() {
        return this.toURI().toPlatformString(true);
    }

    @Override
    protected PlatformResourceURI createFrom(URI uri) {
        return new PlatformResourceURI(uri);
    }

    @Override
    public PlatformResourceURI getParent() {
        URI uri = this.toURI();
        if (uri.segmentCount() > 2) {
            return new PlatformResourceURI(uri.trimSegments(1));
        }
        return null;
    }

    @Override
    public FileURI resolveSymLinks() {
        File file = this.toJavaIoFile();
        try {
            return new FileURI(file.getCanonicalFile());
        }
        catch (IOException e) {
            return new FileURI(file);
        }
    }

    @Override
    public Iterator<PlatformResourceURI> getAllChildren() {
        IResource container = this.getCachedResource();
        if (container instanceof IContainer) {
            final ArrayList result = Lists.newArrayList();
            try {
                container.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource.getType() == 1) {
                            result.add(new PlatformResourceURI(resource));
                        }
                        return resource.getType() != 2 || !resource.getName().equals("node_modules");
                    }
                });
                return Iterators.unmodifiableIterator(result.iterator());
            }
            catch (CoreException e) {
                return Iterators.unmodifiableIterator(result.iterator());
            }
        }
        return Iterators.unmodifiableIterator(Collections.emptyIterator());
    }

    @Override
    public void delete(Consumer<? super IOException> errorHandler) {
        try {
            IResource r = this.getCachedResource();
            if (r == null) {
                return;
            }
            r.delete(false, null);
        }
        catch (CoreException e) {
            errorHandler.accept(new IOException(e));
        }
    }

    @Override
    public FileURI toFileURI() {
        return new FileURI(this.toJavaIoFile());
    }

    @Override
    public File toJavaIoFile() {
        IResource r = this.getCachedResource();
        if (r == null) {
            IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            IPath doesNotExist = workspaceLocation.append(this.toURI().toPlatformString(true));
            return doesNotExist.toFile();
        }
        return r.getLocation().toFile();
    }
}

