/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.compileTime.CompileTimeValue;
import org.eclipse.n4js.flowgraphs.dataflow.guards.InstanceofGuard;
import org.eclipse.n4js.n4JS.AdditiveExpression;
import org.eclipse.n4js.n4JS.AdditiveOperator;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.ArrayPadding;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AwaitExpression;
import org.eclipse.n4js.n4JS.BinaryBitwiseExpression;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.BindingElement;
import org.eclipse.n4js.n4JS.BooleanLiteral;
import org.eclipse.n4js.n4JS.CastExpression;
import org.eclipse.n4js.n4JS.CatchVariable;
import org.eclipse.n4js.n4JS.CommaExpression;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.GetterDeclaration;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.ImportCallExpression;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.IntLiteral;
import org.eclipse.n4js.n4JS.JSXElement;
import org.eclipse.n4js.n4JS.JSXFragment;
import org.eclipse.n4js.n4JS.LocalArgumentsVariable;
import org.eclipse.n4js.n4JS.MemberAccess;
import org.eclipse.n4js.n4JS.MigrationContextVariable;
import org.eclipse.n4js.n4JS.MultiplicativeExpression;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassExpression;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.NewTarget;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.NumericLiteral;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PostfixExpression;
import org.eclipse.n4js.n4JS.PromisifyExpression;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.PropertySpread;
import org.eclipse.n4js.n4JS.RegularExpressionLiteral;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.n4JS.SetterDeclaration;
import org.eclipse.n4js.n4JS.ShiftExpression;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.TaggedTemplateString;
import org.eclipse.n4js.n4JS.TemplateLiteral;
import org.eclipse.n4js.n4JS.TemplateSegment;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.n4JS.util.N4JSSwitch;
import org.eclipse.n4js.n4idl.versioning.MigrationUtils;
import org.eclipse.n4js.n4jsx.ReactHelper;
import org.eclipse.n4js.postprocessing.ASTFlowInfo;
import org.eclipse.n4js.postprocessing.ASTMetaInfoUtils;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.scoping.members.MemberScopingHelper;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TEnumLiteral;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TStructuralType;
import org.eclipse.n4js.ts.types.TTypedElement;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.util.TypesSwitch;
import org.eclipse.n4js.ts.utils.TypeExtensions;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.AbstractJudgment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.utils.DestructureHelper;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.PromisifyHelper;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.Pair;

class TypeJudgment
extends AbstractJudgment {
    @Inject
    private PromisifyHelper promisifyHelper;
    @Inject
    private MemberScopingHelper memberScopingHelper;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private DestructureHelper destructureHelper;
    @Inject
    private JavaScriptVariantHelper javaScriptVariantHelper;
    @Inject
    private ReactHelper reactHelper;

    TypeJudgment() {
    }

    public TypeRef apply(RuleEnvironment G, TypableElement element) {
        TypeRef result = this.doApply(G, element);
        if (result == null) {
            String stringRep = element != null ? element.eClass().getName() : "<null>";
            throw new IllegalStateException("null return value in type judgment for element: " + stringRep);
        }
        return result;
    }

    private TypeRef doApply(RuleEnvironment G, TypableElement element) {
        if (element == null) {
            return TypeJudgment.unknown();
        }
        EPackage elementPkg = element.eClass().getEPackage();
        if (elementPkg == TypesPackage.eINSTANCE) {
            return (TypeRef)new TypeJudgmentSwitchForTypes(G).doSwitch((EObject)element);
        }
        if (elementPkg == N4JSPackage.eINSTANCE) {
            return (TypeRef)new TypeJudgmentSwitchForASTNodes(G).doSwitch((EObject)element);
        }
        throw new IllegalStateException("element belongs to unsupported EPackage: " + elementPkg.getName());
    }

    private static boolean hasFormalParameterWithThisType(FunctionTypeExpression fte) {
        TreeIterator iter = fte.eAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            if (!(obj instanceof TFormalParameter) || !(((TFormalParameter)obj).getTypeRef() instanceof ThisTypeRef)) continue;
            return true;
        }
        return false;
    }

    private final class TypeJudgmentSwitchForASTNodes
    extends N4JSSwitch<TypeRef> {
        private final RuleEnvironment G;

        private TypeJudgmentSwitchForASTNodes(RuleEnvironment G) {
            this.G = G;
        }

        public TypeRef defaultCase(EObject object) {
            throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " missing case-method for " + object.eClass().getName());
        }

        public TypeRef caseTypeDefiningElement(TypeDefiningElement elem) {
            TypeRef defTypeRef = TypeUtils.wrapTypeInTypeRef((Type)elem.getDefinedType(), (TypeArgument[])new TypeArgument[0]);
            return defTypeRef != null ? defTypeRef : TypeJudgment.unknown();
        }

        public TypeRef caseObjectLiteral(ObjectLiteral ol) {
            ParameterizedTypeRefStructural ptr = TypeRefsFactory.eINSTANCE.createParameterizedTypeRefStructural();
            ptr.setDeclaredType((Type)RuleEnvironmentExtensions.objectType(this.G));
            ptr.setStructuralType((TStructuralType)ol.getDefinedType());
            ptr.setDefinedTypingStrategy(TypingStrategy.STRUCTURAL);
            return ptr;
        }

        public TypeRef casePropertyNameValuePair(PropertyNameValuePair property) {
            TypeRef T;
            if (property.getDeclaredTypeRef() != null) {
                T = property.getDeclaredTypeRef();
            } else if (property.getExpression() != null) {
                TypeRef E = TypeJudgment.this.ts.type(this.G, (TypableElement)property.getExpression());
                T = TypeJudgment.this.typeSystemHelper.sanitizeTypeOfVariableFieldPropertyParameter(this.G, (TypeArgument)E);
            } else {
                T = RuleEnvironmentExtensions.anyTypeRef(this.G);
            }
            return T;
        }

        public TypeRef caseN4FieldDeclaration(N4FieldDeclaration fieldDecl) {
            TypeRef T;
            if (fieldDecl.getDeclaredTypeRef() != null) {
                T = fieldDecl.getDeclaredTypeRef();
            } else if (fieldDecl.getExpression() != null) {
                TypeRef E = TypeJudgment.this.ts.type(this.G, (TypableElement)fieldDecl.getExpression());
                T = TypeJudgment.this.typeSystemHelper.sanitizeTypeOfVariableFieldPropertyParameter(this.G, (TypeArgument)E);
            } else {
                T = RuleEnvironmentExtensions.anyTypeRef(this.G);
            }
            return T;
        }

        public TypeRef caseVariableDeclaration(VariableDeclaration vdecl) {
            Object T;
            if (vdecl.getDeclaredTypeRef() != null) {
                T = vdecl.getDeclaredTypeRef();
            } else if (vdecl.eContainer() instanceof BindingElement) {
                Pair guardKey = Pair.of((Object)"varDecl", (Object)vdecl.getExpression());
                if (this.G.get(guardKey) == null) {
                    RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
                    G2.put(guardKey, Boolean.TRUE);
                    TypeRef raw = TypeJudgment.this.destructureHelper.getTypeOfVariableDeclarationInDestructuringPattern(G2, vdecl);
                    T = raw != null ? raw : RuleEnvironmentExtensions.anyTypeRef(this.G);
                } else {
                    T = RuleEnvironmentExtensions.anyTypeRef(this.G);
                }
            } else if (vdecl.eContainer() instanceof ForStatement && ((ForStatement)vdecl.eContainer()).isForOf()) {
                ForStatement forOfStmnt = (ForStatement)vdecl.eContainer();
                Pair guardKey = Pair.of((Object)"varDecl", (Object)vdecl.eContainer());
                if (this.G.get(guardKey) == null) {
                    RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
                    G2.put(guardKey, Boolean.TRUE);
                    TypeRef ofPartTypeRef = TypeJudgment.this.ts.type(G2, (TypableElement)forOfStmnt.getExpression());
                    TypeArgument elemType = TypeJudgment.this.tsh.extractIterableElementType(G2, ofPartTypeRef);
                    T = elemType != null ? TypeJudgment.this.typeSystemHelper.sanitizeTypeOfVariableFieldPropertyParameter(G2, elemType) : TypeJudgment.unknown();
                } else {
                    T = RuleEnvironmentExtensions.anyTypeRef(this.G);
                }
            } else if (vdecl.eContainer() instanceof ForStatement && ((ForStatement)vdecl.eContainer()).isForIn()) {
                T = RuleEnvironmentExtensions.stringTypeRef(this.G);
            } else if (vdecl.getExpression() != null) {
                Pair guardKey = Pair.of((Object)"varDecl", (Object)vdecl.getExpression());
                if (this.G.get(guardKey) == null) {
                    RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
                    G2.put(guardKey, Boolean.TRUE);
                    TypeRef E = TypeJudgment.this.ts.type(G2, (TypableElement)vdecl.getExpression());
                    if (!(E instanceof BoundThisTypeRef || E instanceof TypeTypeRef && ((TypeTypeRef)E).getTypeArg() instanceof BoundThisTypeRef || E instanceof UnknownTypeRef)) {
                        E = TypeJudgment.this.typeSystemHelper.sanitizeTypeOfVariableFieldPropertyParameter(G2, (TypeArgument)E);
                    }
                    T = E.getDeclaredType() == RuleEnvironmentExtensions.undefinedType(this.G) || E.getDeclaredType() == RuleEnvironmentExtensions.nullType(this.G) || E.getDeclaredType() == RuleEnvironmentExtensions.voidType(this.G) ? RuleEnvironmentExtensions.anyTypeRef(this.G) : E;
                } else {
                    T = RuleEnvironmentExtensions.anyTypeRef(this.G);
                }
            } else {
                T = RuleEnvironmentExtensions.anyTypeRef(this.G);
            }
            if (TypeJudgment.this.javaScriptVariantHelper.enforceDynamicTypes((EObject)vdecl)) {
                return TypeJudgment.this.typeSystemHelper.makeDynamic((TypeRef)T);
            }
            return T;
        }

        public TypeRef caseGetterDeclaration(GetterDeclaration getter) {
            TypeRef defDeclTypeRef;
            TypeRef declTypeRef = getter.getDeclaredTypeRef();
            if (declTypeRef != null) {
                return declTypeRef;
            }
            TGetter defGetter = getter.getDefinedGetter();
            TypeRef typeRef = defDeclTypeRef = defGetter != null ? defGetter.getDeclaredTypeRef() : null;
            if (defDeclTypeRef != null) {
                return defDeclTypeRef;
            }
            return RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseSetterDeclaration(SetterDeclaration setter) {
            TypeRef defDeclTypeRef;
            TypeRef declTypeRef = setter.getDeclaredTypeRef();
            if (declTypeRef != null) {
                return declTypeRef;
            }
            TSetter defSetter = setter.getDefinedSetter();
            TypeRef typeRef = defDeclTypeRef = defSetter != null ? defSetter.getDeclaredTypeRef() : null;
            if (defDeclTypeRef != null) {
                return defDeclTypeRef;
            }
            return RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseFormalParameter(FormalParameter fpar) {
            ParameterizedTypeRef T;
            TypeRef fparTypeRef = fpar.getDeclaredTypeRef();
            if (fparTypeRef != null) {
                boolean case2;
                boolean case1 = fparTypeRef instanceof ThisTypeRefStructural;
                boolean bl = case2 = fparTypeRef instanceof FunctionTypeExpression && TypeJudgment.hasFormalParameterWithThisType((FunctionTypeExpression)fparTypeRef);
                if (case1 || case2) {
                    T = TypeJudgment.this.typeSystemHelper.bindAndSubstituteThisTypeRef(this.G, (EObject)fparTypeRef, fparTypeRef);
                } else {
                    TypeRef definedElemTypeRef;
                    TFormalParameter definedElem = fpar.getDefinedTypeElement();
                    TypeRef typeRef = definedElemTypeRef = definedElem != null ? definedElem.getTypeRef() : null;
                    T = definedElemTypeRef != null ? definedElemTypeRef : fparTypeRef;
                }
            } else if (fpar.isHasInitializerAssignment()) {
                Expression initExpr = fpar.getInitializer();
                if (initExpr != null) {
                    TypeRef E = TypeJudgment.this.ts.type(this.G, (TypableElement)initExpr);
                    T = TypeJudgment.this.typeSystemHelper.sanitizeTypeOfVariableFieldPropertyParameter(this.G, (TypeArgument)E);
                } else {
                    T = RuleEnvironmentExtensions.anyTypeRef(this.G);
                }
            } else {
                T = TypeJudgment.this.javaScriptVariantHelper.enforceDynamicTypes((EObject)fpar) ? RuleEnvironmentExtensions.anyTypeRefDynamic(this.G) : RuleEnvironmentExtensions.anyTypeRef(this.G);
            }
            return TypeUtils.wrapIfVariadic((BuiltInTypeScope)RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)this.G).builtInTypeScope, (TypeRef)T, (FormalParameter)fpar);
        }

        public TypeRef caseNullLiteral(NullLiteral object) {
            return RuleEnvironmentExtensions.nullTypeRef(this.G);
        }

        public TypeRef caseBooleanLiteral(BooleanLiteral object) {
            return RuleEnvironmentExtensions.booleanTypeRef(this.G);
        }

        public TypeRef caseNumericLiteral(NumericLiteral l) {
            return N4JSLanguageUtils.isIntLiteral(l) ? RuleEnvironmentExtensions.intTypeRef(this.G) : RuleEnvironmentExtensions.numberTypeRef(this.G);
        }

        public TypeRef caseStringLiteral(StringLiteral object) {
            return RuleEnvironmentExtensions.stringTypeRef(this.G);
        }

        public TypeRef caseRegularExpressionLiteral(RegularExpressionLiteral object) {
            return RuleEnvironmentExtensions.regexpTypeRef(this.G);
        }

        public TypeRef caseTaggedTemplateString(TaggedTemplateString object) {
            return RuleEnvironmentExtensions.stringTypeRef(this.G);
        }

        public TypeRef caseTemplateLiteral(TemplateLiteral object) {
            return RuleEnvironmentExtensions.stringTypeRef(this.G);
        }

        public TypeRef caseTemplateSegment(TemplateSegment object) {
            return RuleEnvironmentExtensions.stringTypeRef(this.G);
        }

        public TypeRef caseArrayLiteral(ArrayLiteral object) {
            throw new IllegalStateException("rule caseArrayLiteral() should never be invoked (PolyComputer is responsible for typing ArrayLiterals)");
        }

        public TypeRef caseArrayPadding(ArrayPadding object) {
            throw new IllegalStateException("rule caseArrayPadding() should never be invoked (PolyComputer is responsible for typing ArrayLiterals and their children)");
        }

        public TypeRef caseArrayElement(ArrayElement e) {
            throw new IllegalStateException("rule caseArrayElement() should never be invoked (PolyComputer is responsible for typing ArrayLiterals and their children)");
        }

        public TypeRef caseIdentifierRef(IdentifierRef idref) {
            TMethod callableCtorFunction;
            TypeRef T = TypeJudgment.this.ts.type(this.G, (TypableElement)idref.getId());
            ASTFlowInfo flowInfo = ((N4JSResource)idref.eResource()).getASTMetaInfoCache().getFlowInfo();
            Collection alwaysHoldingTypes = flowInfo.instanceofGuardAnalyser.getAlwaysHoldingTypes((ControlFlowElement)idref);
            if (!alwaysHoldingTypes.isEmpty()) {
                LinkedList<TypeRef> intersectionTypes = new LinkedList<TypeRef>();
                if (T != null) {
                    intersectionTypes.add(T);
                }
                for (InstanceofGuard ioGuard : alwaysHoldingTypes) {
                    TypeTypeRef ttRef;
                    TypeArgument typeArg;
                    IdentifiableElement guardedElement;
                    if (!(ioGuard.symbolCFE instanceof IdentifierRef) || (guardedElement = ((IdentifierRef)ioGuard.symbolCFE).getId()) == null || idref.getId() != guardedElement) continue;
                    Expression typeIdentifier = ioGuard.typeIdentifier;
                    TypeRef instanceofType = TypeJudgment.this.ts.type(this.G, (TypableElement)typeIdentifier);
                    if (instanceofType instanceof TypeTypeRef && (typeArg = (ttRef = (TypeTypeRef)instanceofType).getTypeArg()) instanceof TypeRef) {
                        instanceofType = (TypeRef)typeArg;
                    }
                    TypeUtils.sanitizeRawTypeRef((TypeRef)instanceofType);
                    intersectionTypes.add(instanceofType);
                }
                if (!intersectionTypes.isEmpty()) {
                    T = TypeJudgment.this.tsh.createIntersectionType(this.G, intersectionTypes.toArray(new TypeRef[intersectionTypes.size()]));
                }
            }
            if ((T = TypeJudgment.this.n4idlVersionResolver.resolveVersion(T, idref)) != null && idref.eContainer() instanceof ParameterizedCallExpression && idref.eContainmentFeature() == N4JSPackage.eINSTANCE.getParameterizedCallExpression_Target() && (callableCtorFunction = TypeJudgment.this.typeSystemHelper.getCallableClassConstructorFunction(this.G, T)) != null) {
                T = TypeExtensions.ref((TFunction)callableCtorFunction, (TypeArgument[])new TypeArgument[0]);
            }
            T = !N4JSASTUtils.isWriteAccess((EObject)idref) ? TypeJudgment.this.ts.substTypeVariablesWithFullCapture(this.G, T) : TypeJudgment.this.ts.substTypeVariables(this.G, T);
            return T;
        }

        public TypeRef caseN4EnumLiteral(N4EnumLiteral enumLiteral) {
            N4EnumDeclaration enumDecl = (N4EnumDeclaration)EcoreUtil2.getContainerOfType((EObject)enumLiteral, N4EnumDeclaration.class);
            TEnum tEnum = enumDecl != null ? enumDecl.getDefinedTypeAsEnum() : null;
            return tEnum != null ? TypeExtensions.ref((Type)tEnum, (TypeArgument[])new TypeArgument[0]) : TypeJudgment.unknown();
        }

        public TypeRef caseThisLiteral(ThisLiteral t) {
            TypeRef rawT = TypeJudgment.this.typeSystemHelper.getThisTypeAtLocation(this.G, (EObject)t);
            return (rawT = TypeJudgment.this.n4idlVersionResolver.resolveVersion(rawT, rawT)) != null ? TypeUtils.enforceNominalTyping((TypeRef)rawT) : TypeJudgment.unknown();
        }

        public TypeRef caseSuperLiteral(SuperLiteral superLiteral) {
            TClassifier superClassifier;
            N4MemberDeclaration containingMemberDecl = (N4MemberDeclaration)EcoreUtil2.getContainerOfType((EObject)superLiteral.eContainer(), N4MemberDeclaration.class);
            if (containingMemberDecl == null) {
                return TypeJudgment.unknown();
            }
            EObject container = containingMemberDecl.eContainer();
            if (!(container instanceof N4ClassDeclaration)) {
                return TypeJudgment.unknown();
            }
            TClass containingClass = ((N4ClassDeclaration)container).getDefinedTypeAsClass();
            if (containingClass == null) {
                return TypeJudgment.unknown();
            }
            TClassifier effectiveSuperClassifier = superClassifier = RuleEnvironmentExtensions.getDeclaredOrImplicitSuperType(this.G, containingClass);
            if (containingClass.isStaticPolyfill()) {
                if (superClassifier instanceof TClass) {
                    effectiveSuperClassifier = RuleEnvironmentExtensions.getDeclaredOrImplicitSuperType(this.G, (TClass)superClassifier);
                } else if (superClassifier instanceof TObjectPrototype) {
                    Type superType;
                    ParameterizedTypeRef superTypeRef = ((TObjectPrototype)superClassifier).getSuperType();
                    Type type = superType = superTypeRef != null ? superTypeRef.getDeclaredType() : null;
                    if (superType instanceof TClassifier) {
                        effectiveSuperClassifier = (TClassifier)superType;
                    }
                }
            }
            if (superLiteral.eContainer() instanceof ParameterizedPropertyAccessExpression || superLiteral.eContainer() instanceof IndexedAccessExpression) {
                Object T = effectiveSuperClassifier != null ? (containingMemberDecl.isStatic() ? TypeUtils.createConstructorTypeRef((Type)effectiveSuperClassifier, (TypeArgument[])new TypeArgument[0]) : TypeUtils.createTypeRef((Type)effectiveSuperClassifier, (TypeArgument[])new TypeArgument[0])) : null;
                return T != null ? TypeUtils.enforceNominalTyping(T) : TypeJudgment.unknown();
            }
            if (superLiteral.eContainer() instanceof ParameterizedCallExpression) {
                if (containingMemberDecl.isConstructor()) {
                    TMethod ctor = TypeJudgment.this.containerTypesHelper.fromContext(superLiteral.eResource()).findConstructor((ContainerType<?>)effectiveSuperClassifier);
                    return ctor != null ? TypeUtils.createTypeRef((Type)ctor, (TypeArgument[])new TypeArgument[0]) : TypeJudgment.unknown();
                }
                return TypeJudgment.unknown();
            }
            if (superLiteral.eContainer() instanceof NewExpression) {
                return TypeJudgment.unknown();
            }
            return TypeJudgment.unknown();
        }

        public TypeRef caseParenExpression(ParenExpression e) {
            return TypeJudgment.this.ts.type(this.G, (TypableElement)e.getExpression());
        }

        public TypeRef caseYieldExpression(YieldExpression y) {
            TypeRef actualGenTypeRef;
            ParameterizedTypeRef itTypeRef;
            boolean isIterable;
            BuiltInTypeScope scope;
            Expression yieldValue;
            TypeRef yieldValueTypeRef;
            Object t = y.isMany() ? (TypeUtils.isGenerator((TypeRef)(yieldValueTypeRef = TypeJudgment.this.ts.type(this.G, (TypableElement)(yieldValue = y.getExpression()))), (BuiltInTypeScope)(scope = RuleEnvironmentExtensions.getPredefinedTypes((RuleEnvironment)this.G).builtInTypeScope)) ? TypeJudgment.this.typeSystemHelper.getGeneratorTReturn(this.G, yieldValueTypeRef) : ((isIterable = TypeJudgment.this.ts.subtype(this.G, (TypeArgument)yieldValueTypeRef, (TypeArgument)(itTypeRef = RuleEnvironmentExtensions.iterableTypeRef(this.G, new TypeArgument[]{TypeUtils.createWildcard()}))).isSuccess()) ? scope.getAnyTypeRef() : RuleEnvironmentExtensions.anyTypeRef(this.G))) : ((actualGenTypeRef = TypeJudgment.this.typeSystemHelper.getActualGeneratorReturnType(this.G, (Expression)y)) != null ? TypeJudgment.this.typeSystemHelper.getGeneratorTNext(this.G, actualGenTypeRef) : RuleEnvironmentExtensions.anyTypeRef(this.G));
            return t != null ? t : RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseAwaitExpression(AwaitExpression e) {
            TypeRef promisifiedReturnTypeRef;
            TypeRef exprType = TypeJudgment.this.ts.type(this.G, (TypableElement)e.getExpression());
            TypeRef T = exprType.getDeclaredType() == RuleEnvironmentExtensions.promiseType(this.G) ? TypeJudgment.this.ts.upperBound(this.G, (TypeArgument)exprType.getTypeArgs().get(0)) : (TypeJudgment.this.promisifyHelper.isPromisifiableExpression(e.getExpression()) ? ((promisifiedReturnTypeRef = TypeJudgment.this.promisifyHelper.extractPromisifiedReturnType(e.getExpression())).getDeclaredType() == RuleEnvironmentExtensions.promiseType(this.G) ? TypeJudgment.this.ts.upperBound(this.G, (TypeArgument)promisifiedReturnTypeRef.getTypeArgs().get(0)) : promisifiedReturnTypeRef) : exprType);
            return T;
        }

        public TypeRef casePromisifyExpression(PromisifyExpression e) {
            return TypeJudgment.this.promisifyHelper.extractPromisifiedReturnType(e.getExpression());
        }

        public TypeRef caseIndexedAccessExpression(IndexedAccessExpression expr) {
            Object T;
            if (expr.getTarget() == null || expr.getIndex() == null) {
                return TypeJudgment.unknown();
            }
            if (expr.getTarget() instanceof SuperLiteral) {
                return TypeJudgment.unknown();
            }
            TypeRef targetTypeRef = TypeJudgment.this.ts.type(this.G, (TypableElement)expr.getTarget());
            targetTypeRef = TypeJudgment.this.ts.upperBoundWithReopenAndResolve(this.G, (TypeArgument)targetTypeRef);
            TypeRef indexTypeRef = TypeJudgment.this.ts.type(this.G, (TypableElement)expr.getIndex());
            Type targetDeclType = targetTypeRef.getDeclaredType();
            boolean targetIsLiteralOfStringBasedEnum = targetDeclType instanceof TEnum && AnnotationDefinition.STRING_BASED.hasAnnotation((TAnnotableElement)targetDeclType);
            boolean indexIsNumeric = TypeJudgment.this.ts.subtype(this.G, (TypeArgument)indexTypeRef, (TypeArgument)RuleEnvironmentExtensions.numberTypeRef(this.G)).isSuccess();
            CompileTimeValue indexValue = ASTMetaInfoUtils.getCompileTimeValue(expr.getIndex());
            String memberName = N4JSLanguageUtils.derivePropertyNameFromCompileTimeValue(indexValue);
            if (indexIsNumeric && (targetTypeRef.isArrayLike() || targetIsLiteralOfStringBasedEnum)) {
                if (targetDeclType.isGeneric() && targetTypeRef.getTypeArgs().isEmpty()) {
                    T = RuleEnvironmentExtensions.anyTypeRef(this.G);
                } else {
                    RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
                    TypeJudgment.this.typeSystemHelper.addSubstitutions(G2, targetTypeRef);
                    RuleEnvironmentExtensions.addThisType(G2, targetTypeRef);
                    TypeRef elementTypeRef = targetIsLiteralOfStringBasedEnum ? RuleEnvironmentExtensions.stringType(this.G).getElementType() : targetDeclType.getElementType();
                    T = TypeJudgment.this.ts.substTypeVariables(G2, elementTypeRef);
                }
            } else if (memberName != null) {
                EObject member;
                boolean staticAccess = targetTypeRef instanceof TypeTypeRef;
                boolean structFieldInitMode = targetTypeRef.getTypingStrategy() == TypingStrategy.STRUCTURAL_FIELD_INITIALIZER;
                boolean checkVisibility = false;
                IScope scope = TypeJudgment.this.memberScopingHelper.createMemberScope(targetTypeRef, (MemberAccess)expr, false, staticAccess, structFieldInitMode);
                IEObjectDescription memberDesc = !memberName.isEmpty() ? scope.getSingleElement(TypeJudgment.this.qualifiedNameConverter.toQualifiedName(memberName)) : null;
                EObject eObject = member = memberDesc != null && !IEObjectDescriptionWithError.isErrorDescription(memberDesc) ? memberDesc.getEObjectOrProxy() : null;
                if (member instanceof TMember && !member.eIsProxy()) {
                    TypeRef memberTypeRef = TypeJudgment.this.ts.type(this.G, (TypableElement)((TMember)member));
                    RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
                    TypeJudgment.this.typeSystemHelper.addSubstitutions(G2, targetTypeRef);
                    RuleEnvironmentExtensions.addThisType(G2, targetTypeRef);
                    T = TypeJudgment.this.ts.substTypeVariables(G2, memberTypeRef);
                } else {
                    T = targetTypeRef.isDynamic() ? RuleEnvironmentExtensions.anyTypeRefDynamic(this.G) : TypeJudgment.unknown();
                }
            } else {
                T = targetTypeRef.isDynamic() ? RuleEnvironmentExtensions.anyTypeRefDynamic(this.G) : RuleEnvironmentExtensions.anyTypeRef(this.G);
            }
            return T;
        }

        public TypeRef caseParameterizedPropertyAccessExpression(ParameterizedPropertyAccessExpression expr) {
            FunctionTypeExprOrRef F;
            ParameterizedTypeRef propTypeRef;
            Pair guardKey = Pair.of((Object)"typePropertyAccessExpression", (Object)expr);
            Object guardValue = this.G.get(guardKey);
            if (guardValue instanceof TypeRef) {
                return (TypeRef)guardValue;
            }
            RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
            G2.put(guardKey, RuleEnvironmentExtensions.anyTypeRef(G2));
            TypeRef receiverTypeRef = TypeJudgment.this.ts.type(G2, (TypableElement)expr.getTarget());
            TypeJudgment.this.typeSystemHelper.addSubstitutions(G2, receiverTypeRef);
            RuleEnvironmentExtensions.addThisType(G2, receiverTypeRef);
            if (!(receiverTypeRef instanceof UnknownTypeRef) && (expr.getTarget() instanceof SuperLiteral || expr.getTarget() instanceof ThisLiteral)) {
                Object containingClass;
                N4ClassDeclaration containingClassDecl = (N4ClassDeclaration)EcoreUtil2.getContainerOfType((EObject)expr, N4ClassDeclaration.class);
                Type type = containingClass = containingClassDecl != null ? containingClassDecl.getDefinedType() : null;
                if (containingClass instanceof TClass) {
                    ParameterizedTypeRef superClassRef;
                    if (containingClass.isStaticPolyfill()) {
                        superClassRef = ((TClass)containingClass).getSuperClassRef();
                        containingClass = superClassRef != null ? superClassRef.getDeclaredType() : null;
                    }
                    if (containingClass instanceof TClass && (superClassRef = ((TClass)containingClass).getSuperClassRef()) != null) {
                        TypeJudgment.this.typeSystemHelper.addSubstitutions(G2, (TypeRef)superClassRef);
                    }
                }
            }
            TypeRef receiverTypeRefUB = TypeJudgment.this.ts.upperBoundWithReopen(G2, (TypeArgument)receiverTypeRef);
            IdentifiableElement prop = expr.getProperty();
            if (prop instanceof TMethod && ((TMethod)prop).isConstructor()) {
                Object ctorTypeArg;
                if (receiverTypeRefUB instanceof TypeTypeRef) {
                    ctorTypeArg = RuleEnvironmentExtensions.functionTypeRef(this.G);
                } else {
                    boolean finalCtorSig;
                    Type declType = receiverTypeRefUB.getDeclaredType();
                    boolean bl = finalCtorSig = declType instanceof TClassifier && N4JSLanguageUtils.hasCovariantConstructor((TClassifier)declType);
                    ctorTypeArg = finalCtorSig ? TypeExtensions.ref((Type)declType, (TypeArgument[])new TypeArgument[0]) : (declType != null ? TypeUtils.createWildcardExtends((TypeRef)TypeExtensions.ref((Type)declType, (TypeArgument[])new TypeArgument[0])) : null);
                }
                propTypeRef = ctorTypeArg != null ? TypeUtils.createTypeTypeRef((TypeArgument)ctorTypeArg, (boolean)true) : TypeJudgment.unknown();
            } else if (receiverTypeRefUB.isDynamic() && prop != null && prop.eIsProxy()) {
                propTypeRef = RuleEnvironmentExtensions.anyTypeRefDynamic(G2);
            } else {
                propTypeRef = TypeJudgment.this.ts.type(RuleEnvironmentExtensions.wrap(G2), (TypableElement)prop);
                if (expr.isParameterized()) {
                    TypeJudgment.this.typeSystemHelper.addSubstitutions(G2, expr);
                }
            }
            ParameterizedTypeRef T = propTypeRef;
            T = !N4JSASTUtils.isWriteAccess((EObject)expr) ? TypeJudgment.this.ts.substTypeVariablesWithFullCapture(G2, (TypeRef)T) : TypeJudgment.this.ts.substTypeVariablesWithPartialCapture(G2, (TypeRef)T);
            T = (TypeRef)TypeJudgment.this.n4idlVersionResolver.resolveVersion(T, receiverTypeRef);
            if (expr.getTarget() instanceof SuperLiteral && T instanceof FunctionTypeExprOrRef && (F = (FunctionTypeExprOrRef)T).getReturnTypeRef() instanceof BoundThisTypeRef) {
                TypeRef rawT = TypeJudgment.this.typeSystemHelper.getThisTypeAtLocation(G2, (EObject)expr);
                TypeRef thisTypeRef = TypeUtils.enforceNominalTyping((TypeRef)rawT);
                if (F instanceof FunctionTypeExpression && F.eContainer() == null) {
                    FunctionTypeExpression FTE = (FunctionTypeExpression)F;
                    FTE.setReturnTypeRef((TypeRef)TypeUtils.copyIfContained((EObject)thisTypeRef));
                } else {
                    T = TypeUtils.createFunctionTypeExpression(null, (List)F.getTypeVars(), (List)F.getFpars(), (TypeRef)thisTypeRef);
                }
            }
            return T;
        }

        public TypeRef caseParameterizedCallExpression(ParameterizedCallExpression expr) {
            TypeRef targetTypeRef = TypeJudgment.this.ts.type(this.G, (TypableElement)expr.getTarget());
            if (targetTypeRef instanceof FunctionTypeExprOrRef) {
                Object T;
                FunctionTypeExprOrRef F = (FunctionTypeExprOrRef)targetTypeRef;
                TFunction tFunction = F.getFunctionType();
                Pair guardKey = Pair.of((Object)"typeCallExpression", (Object)expr);
                Object guardValue = this.G.get(guardKey);
                if (guardValue instanceof TypeRef) {
                    T = TypeJudgment.this.ts.substTypeVariables(this.G, (TypeRef)guardValue);
                } else {
                    TypeRef rtr;
                    RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
                    G2.put(guardKey, F.getReturnTypeRef());
                    T = expr.eContainer() instanceof AwaitExpression && expr.eContainmentFeature() == N4JSPackage.eINSTANCE.getAwaitExpression_Expression() && tFunction != null && AnnotationDefinition.PROMISIFIABLE.hasAnnotation((TAnnotableElement)tFunction) ? TypeJudgment.this.promisifyHelper.extractPromisifiedReturnType((Expression)expr) : ((rtr = F.getReturnTypeRef()) != null ? rtr : RuleEnvironmentExtensions.anyTypeRef(this.G));
                    TypeJudgment.this.typeSystemHelper.addSubstitutions(G2, expr, targetTypeRef);
                    T = TypeJudgment.this.ts.substTypeVariables(G2, (TypeRef)T);
                    if (T == null) {
                        return TypeJudgment.unknown();
                    }
                    if ((T = TypeJudgment.this.n4idlVersionResolver.resolveVersion(T, F)) instanceof BoundThisTypeRef && !(expr.getReceiver() instanceof ThisLiteral) && !(expr.getReceiver() instanceof SuperLiteral)) {
                        T = TypeJudgment.this.ts.upperBoundWithReopen(G2, (TypeArgument)T);
                    }
                }
                return T;
            }
            if (targetTypeRef.getDeclaredType() == RuleEnvironmentExtensions.functionType(this.G)) {
                return RuleEnvironmentExtensions.anyTypeRef(this.G);
            }
            if (targetTypeRef.isDynamic()) {
                return RuleEnvironmentExtensions.anyTypeRefDynamic(this.G);
            }
            if (MigrationUtils.isMigrateCall((EObject)expr) && targetTypeRef instanceof UnknownTypeRef) {
                return RuleEnvironmentExtensions.anyTypeRefDynamic(this.G);
            }
            return TypeJudgment.unknown();
        }

        public TypeRef caseImportCallExpression(ImportCallExpression object) {
            return RuleEnvironmentExtensions.promiseTypeRef(this.G, new TypeArgument[]{RuleEnvironmentExtensions.anyTypeRefDynamic(this.G), TypeUtils.createWildcard()});
        }

        public TypeRef caseArgument(Argument arg) {
            return TypeJudgment.this.ts.type(this.G, (TypableElement)arg.getExpression());
        }

        public TypeRef caseNewExpression(NewExpression e) {
            TypeRef T = TypeJudgment.this.ts.type(this.G, (TypableElement)e.getCallee());
            if (T instanceof TypeTypeRef) {
                T = TypeJudgment.this.typeSystemHelper.createTypeRefFromStaticType(this.G, (TypeTypeRef)T, (TypeArgument[])e.getTypeArgs().toArray((Object[])new TypeArgument[0]));
            }
            return T;
        }

        public TypeRef caseNewTarget(NewTarget nt) {
            return TypeJudgment.unknown();
        }

        public TypeRef casePostfixExpression(PostfixExpression object) {
            return RuleEnvironmentExtensions.numberTypeRef(this.G);
        }

        public TypeRef caseUnaryExpression(UnaryExpression e) {
            if ((e.getOp() == UnaryOperator.NEG || e.getOp() == UnaryOperator.POS) && e.getExpression() instanceof IntLiteral) {
                return TypeJudgment.this.ts.type(this.G, (TypableElement)e.getExpression());
            }
            switch (e.getOp()) {
                case DELETE: {
                    return RuleEnvironmentExtensions.booleanTypeRef(this.G);
                }
                case VOID: {
                    return RuleEnvironmentExtensions.undefinedTypeRef(this.G);
                }
                case TYPEOF: {
                    return RuleEnvironmentExtensions.stringTypeRef(this.G);
                }
                case NOT: {
                    return RuleEnvironmentExtensions.booleanTypeRef(this.G);
                }
            }
            return RuleEnvironmentExtensions.numberTypeRef(this.G);
        }

        public TypeRef caseMultiplicativeExpression(MultiplicativeExpression object) {
            return RuleEnvironmentExtensions.numberTypeRef(this.G);
        }

        public TypeRef caseAdditiveExpression(AdditiveExpression expr) {
            if (expr.getOp() == AdditiveOperator.ADD) {
                boolean rMayNum;
                TypeRef l = TypeJudgment.this.ts.type(this.G, (TypableElement)expr.getLhs());
                TypeRef r = TypeJudgment.this.ts.type(this.G, (TypableElement)expr.getRhs());
                boolean lunknown = l instanceof UnknownTypeRef;
                boolean runknown = r instanceof UnknownTypeRef;
                if (lunknown && runknown) {
                    return TypeJudgment.this.typeSystemHelper.createUnionType(this.G, new TypeRef[]{RuleEnvironmentExtensions.numberTypeRef(this.G), RuleEnvironmentExtensions.stringTypeRef(this.G)});
                }
                boolean lnum = RuleEnvironmentExtensions.isNumericOperand(this.G, l);
                boolean rnum = RuleEnvironmentExtensions.isNumericOperand(this.G, r);
                if (lnum && rnum) {
                    return RuleEnvironmentExtensions.numberTypeRef(this.G);
                }
                if ((lunknown || runknown) && (lnum || rnum)) {
                    return TypeJudgment.this.typeSystemHelper.createUnionType(this.G, new TypeRef[]{RuleEnvironmentExtensions.numberTypeRef(this.G), RuleEnvironmentExtensions.stringTypeRef(this.G)});
                }
                boolean lMayNum = lnum || RuleEnvironmentExtensions.containsNumericOperand(this.G, l) || RuleEnvironmentExtensions.isAny(this.G, (TypeArgument)l) || RuleEnvironmentExtensions.isSymbol(this.G, (TypeArgument)l);
                boolean bl = rMayNum = rnum || RuleEnvironmentExtensions.containsNumericOperand(this.G, r) || RuleEnvironmentExtensions.isAny(this.G, (TypeArgument)r) || RuleEnvironmentExtensions.isSymbol(this.G, (TypeArgument)r);
                if (lMayNum && rMayNum) {
                    return TypeJudgment.this.typeSystemHelper.createUnionType(this.G, new TypeRef[]{RuleEnvironmentExtensions.numberTypeRef(this.G), RuleEnvironmentExtensions.stringTypeRef(this.G)});
                }
                return RuleEnvironmentExtensions.stringTypeRef(this.G);
            }
            return RuleEnvironmentExtensions.numberTypeRef(this.G);
        }

        public TypeRef caseShiftExpression(ShiftExpression e) {
            return RuleEnvironmentExtensions.numberTypeRef(this.G);
        }

        public TypeRef caseRelationalExpression(RelationalExpression e) {
            return RuleEnvironmentExtensions.booleanTypeRef(this.G);
        }

        public TypeRef caseEqualityExpression(EqualityExpression e) {
            return RuleEnvironmentExtensions.booleanTypeRef(this.G);
        }

        public TypeRef caseBinaryBitwiseExpression(BinaryBitwiseExpression e) {
            return RuleEnvironmentExtensions.numberTypeRef(this.G);
        }

        public TypeRef caseBinaryLogicalExpression(BinaryLogicalExpression e) {
            Expression lhs = e.getLhs();
            Expression rhs = e.getRhs();
            boolean lhsIsEmptyArrayLiteral = lhs instanceof ArrayLiteral && ((ArrayLiteral)lhs).getElements().isEmpty();
            boolean rhsIsEmptyArrayLiteral = rhs instanceof ArrayLiteral && ((ArrayLiteral)rhs).getElements().isEmpty();
            TypeRef L = TypeJudgment.this.ts.type(this.G, (TypableElement)lhs);
            TypeRef R = TypeJudgment.this.ts.type(this.G, (TypableElement)rhs);
            if (lhsIsEmptyArrayLiteral && R.getDeclaredType() == RuleEnvironmentExtensions.arrayType(this.G)) {
                return R;
            }
            if (rhsIsEmptyArrayLiteral && L.getDeclaredType() == RuleEnvironmentExtensions.arrayType(this.G)) {
                return L;
            }
            return TypeJudgment.this.typeSystemHelper.createUnionType(this.G, L, R);
        }

        public TypeRef caseConditionalExpression(ConditionalExpression expr) {
            TypeRef left = TypeJudgment.this.ts.type(this.G, (TypableElement)expr.getTrueExpression());
            TypeRef right = TypeJudgment.this.ts.type(this.G, (TypableElement)expr.getFalseExpression());
            return TypeJudgment.this.typeSystemHelper.createUnionType(this.G, left, right);
        }

        public TypeRef caseAssignmentExpression(AssignmentExpression expr) {
            switch (expr.getOp()) {
                case ASSIGN: {
                    return TypeJudgment.this.ts.type(this.G, (TypableElement)expr.getRhs());
                }
                case ADD_ASSIGN: {
                    boolean undef;
                    TypeRef l = TypeJudgment.this.ts.type(this.G, (TypableElement)expr.getLhs());
                    TypeRef r = TypeJudgment.this.ts.type(this.G, (TypableElement)expr.getRhs());
                    Type lDeclType = l.getDeclaredType();
                    Type rDeclType = r.getDeclaredType();
                    boolean lnum = lDeclType == RuleEnvironmentExtensions.booleanType(this.G) || RuleEnvironmentExtensions.isNumeric(this.G, lDeclType);
                    boolean rnum = rDeclType == RuleEnvironmentExtensions.booleanType(this.G) || RuleEnvironmentExtensions.isNumeric(this.G, rDeclType);
                    boolean bl = undef = lDeclType == RuleEnvironmentExtensions.undefinedType(this.G) || lDeclType == RuleEnvironmentExtensions.nullType(this.G) || rDeclType == RuleEnvironmentExtensions.undefinedType(this.G) || rDeclType == RuleEnvironmentExtensions.nullType(this.G);
                    if (lnum && rnum || undef && (lnum || rnum)) break;
                    return RuleEnvironmentExtensions.stringTypeRef(this.G);
                }
            }
            return RuleEnvironmentExtensions.numberTypeRef(this.G);
        }

        public TypeRef caseCommaExpression(CommaExpression e) {
            if (e.getExprs().isEmpty()) {
                return TypeJudgment.unknown();
            }
            Expression last = (Expression)e.getExprs().get(e.getExprs().size() - 1);
            return TypeJudgment.this.ts.type(this.G, (TypableElement)last);
        }

        public TypeRef caseCastExpression(CastExpression e) {
            TypeRef targetTypeRef = e.getTargetTypeRef();
            return targetTypeRef != null ? targetTypeRef : TypeJudgment.unknown();
        }

        public TypeRef caseN4ClassExpression(N4ClassExpression e) {
            return this.caseTypeDefiningElement((TypeDefiningElement)e);
        }

        public TypeRef caseFunctionExpression(FunctionExpression e) {
            return this.caseTypeDefiningElement((TypeDefiningElement)e);
        }

        public TypeRef caseCatchVariable(CatchVariable catchVariable) {
            if (TypeJudgment.this.javaScriptVariantHelper.enforceDynamicTypes((EObject)catchVariable)) {
                return RuleEnvironmentExtensions.anyTypeRefDynamic(this.G);
            }
            return RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseLocalArgumentsVariable(LocalArgumentsVariable lArgumentsVar) {
            return RuleEnvironmentExtensions.argumentsTypeRef(this.G);
        }

        public TypeRef casePropertySpread(PropertySpread object) {
            return TypeJudgment.unknown();
        }

        public TypeRef caseJSXElement(JSXElement jsxElem) {
            TClassifier classifierReactElement = TypeJudgment.this.reactHelper.lookUpReactElement((EObject)jsxElem);
            if (classifierReactElement == null) {
                return TypeJudgment.unknown();
            }
            return TypeExtensions.ref((Type)classifierReactElement, (TypeArgument[])new TypeArgument[0]);
        }

        public TypeRef caseJSXFragment(JSXFragment jsxFragment) {
            TClassifier classifierReactElement = TypeJudgment.this.reactHelper.lookUpReactElement((EObject)jsxFragment);
            if (classifierReactElement == null) {
                return TypeJudgment.unknown();
            }
            return TypeExtensions.ref((Type)classifierReactElement, (TypeArgument[])new TypeArgument[0]);
        }

        public TypeRef caseMigrationContextVariable(MigrationContextVariable mcv) {
            return RuleEnvironmentExtensions.migrationContextTypeRef(this.G);
        }
    }

    private final class TypeJudgmentSwitchForTypes
    extends TypesSwitch<TypeRef> {
        private final RuleEnvironment G;

        private TypeJudgmentSwitchForTypes(RuleEnvironment G) {
            this.G = G;
        }

        public TypeRef defaultCase(EObject object) {
            throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " missing case-method for " + object.eClass().getName());
        }

        public TypeRef caseType(Type type) {
            return TypeUtils.wrapTypeInTypeRef((Type)type, (TypeArgument[])new TypeArgument[0]);
        }

        public TypeRef caseTEnumLiteral(TEnumLiteral enumLiteral) {
            return TypeExtensions.ref((Type)((TEnum)enumLiteral.eContainer()), (TypeArgument[])new TypeArgument[0]);
        }

        public TypeRef caseTTypedElement(TTypedElement typedElement) {
            TypeRef typeRef = typedElement.getTypeRef();
            return typeRef != null ? typeRef : RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseTGetter(TGetter tGetter) {
            TypeRef declTypeRef = tGetter.getDeclaredTypeRef();
            return declTypeRef != null ? declTypeRef : RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseTSetter(TSetter tSetter) {
            TypeRef declTypeRef = tSetter.getDeclaredTypeRef();
            return declTypeRef != null ? declTypeRef : RuleEnvironmentExtensions.anyTypeRef(this.G);
        }

        public TypeRef caseModuleNamespaceVirtualType(ModuleNamespaceVirtualType mnsvt) {
            return TypeUtils.createTypeRef((Type)mnsvt, (TypeArgument[])new TypeArgument[0]);
        }
    }
}

