/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.contentproposal;

import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ModuleSpecifierContentProposalProviderFactory {
    private static final IContentProposal[] EMPTY_PROPOSAL = new IContentProposal[0];

    public IContentProposalProvider createProviderForPath(IPath root) {
        return new ModuleSpecifierContentProposalProvider(root);
    }

    private static IContainer findContainerForPath(IPath path) {
        IResource containerResource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (containerResource instanceof IContainer) {
            return (IContainer)containerResource;
        }
        return null;
    }

    private static class ModuleSpecifierContentProposalProvider
    implements IContentProposalProvider {
        private final IPath rootFolder;

        private ModuleSpecifierContentProposalProvider(IPath rootFolder) {
            this.rootFolder = rootFolder;
        }

        public IContentProposal[] getProposals(String contents, int position) {
            if (this.rootFolder == null) {
                return EMPTY_PROPOSAL;
            }
            Object proposalRootFolder = this.rootFolder.isEmpty() ? ResourcesPlugin.getWorkspace().getRoot() : (this.rootFolder.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(this.rootFolder.segment(0)) : ModuleSpecifierContentProposalProviderFactory.findContainerForPath(this.rootFolder));
            if (proposalRootFolder == null || !proposalRootFolder.exists()) {
                return EMPTY_PROPOSAL;
            }
            Path contentsPath = new Path(contents);
            Object workingDirectoryPath = contentsPath.hasTrailingSeparator() ? contentsPath : contentsPath.removeLastSegments(1);
            Object workingDirectory = workingDirectoryPath.segmentCount() > 0 ? proposalRootFolder.getFolder((IPath)workingDirectoryPath) : proposalRootFolder;
            if (workingDirectory == null || !workingDirectory.exists()) {
                return EMPTY_PROPOSAL;
            }
            try {
                return (IContentProposal[])Arrays.asList(workingDirectory.members()).stream().filter(r -> r instanceof IFile || r instanceof IFolder).filter(arg_0 -> this.lambda$1((IPath)contentsPath, arg_0)).map(arg_0 -> ModuleSpecifierContentProposalProvider.lambda$2((IContainer)proposalRootFolder, arg_0)).toArray(IContentProposal[]::new);
            }
            catch (CoreException e) {
                return EMPTY_PROPOSAL;
            }
        }

        private /* synthetic */ boolean lambda$1(IPath iPath, IResource resource) {
            IPath rootRelativePath = resource.getFullPath().makeRelativeTo(this.rootFolder);
            return rootRelativePath.toString().startsWith(iPath.toString());
        }

        private static /* synthetic */ ModuleSpecifierProposal lambda$2(IContainer iContainer, IResource resource) {
            IPath proposalPath = resource.getFullPath().makeRelativeTo(iContainer.getFullPath());
            ModuleSpecifierProposal.ModuleProposalType type = resource instanceof IFile ? ModuleSpecifierProposal.ModuleProposalType.MODULE : ModuleSpecifierProposal.ModuleProposalType.FOLDER;
            return ModuleSpecifierProposal.createFromPath(proposalPath, type);
        }
    }

    private static final class ModuleSpecifierProposal
    extends ContentProposal {
        private final ModuleProposalType moduleType;

        static ModuleSpecifierProposal createFromPath(IPath path, ModuleProposalType moduleType) {
            String content = moduleType == ModuleProposalType.FOLDER ? path.removeFileExtension().addTrailingSeparator().toString() : path.removeFileExtension().toString();
            String label = moduleType == ModuleProposalType.FOLDER ? path.addTrailingSeparator().toString() : path.toString();
            return new ModuleSpecifierProposal(content, label, moduleType);
        }

        public ModuleSpecifierProposal(String content, String label, ModuleProposalType moduleType) {
            super(content, label, "");
            this.moduleType = moduleType;
        }

        public ModuleProposalType getModuleType() {
            return this.moduleType;
        }

        public static enum ModuleProposalType {
            FOLDER,
            MODULE;

        }
    }

    public static final class ModuleSpecifierProposalLabelProvider
    extends LabelProvider {
        private static final Image FOLDER_SYMBOL = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private static final Image FILE_SYMBOL = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");

        public Image getImage(Object element) {
            if (element instanceof ModuleSpecifierProposal) {
                ModuleSpecifierProposal.ModuleProposalType type = ((ModuleSpecifierProposal)((Object)element)).getModuleType();
                return type == ModuleSpecifierProposal.ModuleProposalType.FOLDER ? FOLDER_SYMBOL : FILE_SYMBOL;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ModuleSpecifierProposal) {
                return ((ModuleSpecifierProposal)((Object)element)).getLabel();
            }
            return super.getText(element);
        }
    }
}

