/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.xtext.xbase.lib.Pair;

public class N4JSFlowAnalyserDataRecorder {
    private static boolean enabled = false;
    private static List<Pair<Node, List<ControlFlowEdge>>> mergedEdges = new ArrayList<Pair<Node, List<ControlFlowEdge>>>();

    public static void setEnabled(boolean pEnabled) {
        enabled = pEnabled;
        if (pEnabled) {
            N4JSFlowAnalyserDataRecorder.clear();
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void addMergedEdges(Node start, List<ControlFlowEdge> edges) {
        Pair pair = new Pair((Object)start, edges);
        mergedEdges.add((Pair<Node, List<ControlFlowEdge>>)pair);
    }

    public static List<Pair<Node, List<ControlFlowEdge>>> getMergedEdges() {
        Collections.sort(mergedEdges, N4JSFlowAnalyserDataRecorder::compareNodes);
        return mergedEdges;
    }

    static int compareNodes(Pair<Node, List<ControlFlowEdge>> p1, Pair<Node, List<ControlFlowEdge>> p2) {
        Node n1 = (Node)p1.getKey();
        Node n2 = (Node)p2.getKey();
        return n1.getExtendedString().compareTo(n2.getExtendedString());
    }

    private static void clear() {
        mergedEdges.clear();
    }
}

