/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.n4js.smith.Measurement;

class TimedMeasurement
implements Measurement {
    final String name;
    private final Stopwatch sw;
    private boolean consumed = false;
    private Consumer<TimedMeasurement> stopHandler;

    TimedMeasurement(String name, Consumer<TimedMeasurement> stopHandler) {
        this.name = name;
        this.stopHandler = stopHandler;
        this.sw = Stopwatch.createStarted();
    }

    synchronized long elapsed(TimeUnit timeUnit) {
        return this.sw.elapsed(timeUnit);
    }

    @Override
    public synchronized void close() {
        if (this.consumed) {
            return;
        }
        if (this.sw.isRunning()) {
            this.sw.stop();
        }
        this.stopHandler.accept(this);
        this.consumed = true;
        this.stopHandler = null;
    }
}

