/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.domain;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import org.eclipse.n4js.tester.domain.ID;
import org.eclipse.n4js.tester.domain.TestCase;
import org.eclipse.n4js.tester.domain.TestElement;
import org.eclipse.n4js.tester.domain.TestSuite;

@JsonAutoDetect
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TestTree
implements TestElement,
Iterable<TestCase> {
    private List<TestSuite> suites = Lists.newArrayList();
    @JsonProperty
    private ID sessionId;
    @JsonIgnore
    private String name;

    static TestTree copyOf(TestTree tree) {
        return new TestTree(ID.copyOf(tree.sessionId), Lists.newArrayList((Iterable)Iterables.transform(tree.suites, ts -> TestSuite.copyOf(ts))), tree.name);
    }

    private TestTree() {
    }

    public TestTree(ID sessionId) {
        this(sessionId, Lists.newArrayList());
    }

    public TestTree(ID sessionId, Collection<? extends TestSuite> suites) {
        this(sessionId, suites, String.valueOf(sessionId));
    }

    public TestTree(ID sessionId, Collection<? extends TestSuite> suites, String name) {
        this.name = name;
        this.suites = Lists.newArrayList((Iterable)ImmutableList.copyOf(suites));
        this.sessionId = sessionId;
    }

    public List<TestSuite> getSuites() {
        return this.suites;
    }

    public ID getSessionId() {
        return this.sessionId;
    }

    public TestCase getTestCase(String testCaseId) {
        return this.getTestCase(new ID(testCaseId));
    }

    public TestCase getTestCase(ID testCaseId) {
        for (TestSuite suite : this.suites) {
            TestCase testCase = suite.getTestCase(testCaseId);
            if (testCase == null) continue;
            return testCase;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public TestTree sort() {
        Collections.sort(this.suites);
        this.suites.forEach(s -> s.sort());
        return this;
    }

    public TestTree clone() throws CloneNotSupportedException {
        return TestTree.copyOf(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestTree other = (TestTree)obj;
        return !(this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId));
    }

    @Override
    public Iterator<TestCase> iterator() {
        return Iterators.concat((Iterator)Iterators.transform(this.suites.iterator(), (Function)new Function<TestSuite, Iterator<TestCase>>(){

            public Iterator<TestCase> apply(TestSuite suite) {
                return suite.iterator();
            }
        }));
    }

    @Override
    public Spliterator<TestCase> spliterator() {
        int size = Iterators.size(this.iterator());
        return Spliterators.spliterator(this.iterator(), (long)size, 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Session ID: ").append(this.sessionId.toString());
        if (!Iterables.isEmpty(this.suites)) {
            sb.append("\nSuites:");
            for (TestSuite suite : this.suites) {
                sb.append("\n").append(suite);
            }
        }
        return sb.toString();
    }
}

