/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;

public class GeneratedJSFilesCounter {
    public static TreeMap<Path, HashSet<File>> getTranspiledFiles(final Path workspaceRoot) throws IOException {
        File gitRoot = new File(new File("").getAbsolutePath()).getParentFile().getParentFile();
        File n4jsLibrariesRoot = new File(gitRoot, "n4js-libs/packages");
        final HashSet<String> n4jsLibraryNames = new HashSet<String>(Arrays.asList(n4jsLibrariesRoot.list()));
        final AtomicReference genFilesRef = new AtomicReference();
        genFilesRef.set(new TreeMap());
        Files.walkFileTree(workspaceRoot, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if ("src".equals(dir.getFileName().toString())) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (n4jsLibraryNames.contains(dir.toFile().getName())) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().endsWith(".js")) {
                    Path directory;
                    TreeMap fileMap = (TreeMap)genFilesRef.get();
                    if (!fileMap.containsKey(directory = file.getParent())) {
                        fileMap.put(directory, new HashSet());
                    }
                    Path relativeFile = workspaceRoot.relativize(file);
                    ((HashSet)fileMap.get(directory)).add(relativeFile.toFile());
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if ("src-gen".equals(dir.getFileName().toString())) {
                    return FileVisitResult.SKIP_SIBLINGS;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return (TreeMap)genFilesRef.get();
    }
}

