/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.flowgraphs.analysis.DeadFlowContext;
import org.eclipse.n4js.flowgraphs.analysis.EdgeGuide;
import org.eclipse.n4js.flowgraphs.analysis.FinallyFlowContext;
import org.eclipse.n4js.flowgraphs.model.Node;

public class EdgeGuideQueue {
    private final ArrayList<EdgeGuide> edgeGuideQueue = new ArrayList();

    void clear() {
        this.edgeGuideQueue.clear();
    }

    void add(EdgeGuide edgeGuide) {
        this.edgeGuideQueue.add(edgeGuide);
        Collections.sort(this.edgeGuideQueue, this::compareForRemoveFirst);
    }

    void addAll(Collection<EdgeGuide> edgeGuides) {
        this.edgeGuideQueue.addAll(edgeGuides);
        Collections.sort(this.edgeGuideQueue, this::compareForRemoveFirst);
    }

    boolean isEmpty() {
        return this.edgeGuideQueue.isEmpty();
    }

    EdgeGuide removeFirst() {
        return this.edgeGuideQueue.remove(0);
    }

    List<EdgeGuide> removeFirstJoinGuide() {
        LinkedList<EdgeGuide> guideGroup = new LinkedList<EdgeGuide>();
        Iterator<EdgeGuide> iter = this.edgeGuideQueue.iterator();
        while (iter.hasNext()) {
            EdgeGuide eg = iter.next();
            if (!guideGroup.isEmpty() && !this.isJoinGroup((EdgeGuide)guideGroup.getFirst(), eg)) break;
            guideGroup.add(eg);
            if (guideGroup.size() <= 1) continue;
            iter.remove();
        }
        if (guideGroup.size() > 1) {
            this.edgeGuideQueue.remove(guideGroup.getFirst());
            return guideGroup;
        }
        return Collections.emptyList();
    }

    Iterable<EdgeGuide> getIterator() {
        return this.edgeGuideQueue;
    }

    private boolean isJoinGroup(EdgeGuide eg1, EdgeGuide eg2) {
        Node nextN2;
        Node nextN1 = eg1.getNextNode();
        boolean isJoinGroup = nextN1 == (nextN2 = eg2.getNextNode()) && eg1.finallyContext.equals(eg2.finallyContext);
        return isJoinGroup;
    }

    private int compareForRemoveFirst(EdgeGuide eg1, EdgeGuide eg2) {
        return ComparisonChain.start().compare((Object)eg1, (Object)eg2, EdgeGuideQueue::compareASTPosition).compare((Object)eg1, (Object)eg2, EdgeGuideQueue::compareDeadFlowContext).compare((Object)eg1, (Object)eg2, EdgeGuideQueue::compareFinallyContext).result();
    }

    private static int compareDeadFlowContext(EdgeGuide eg1, EdgeGuide eg2) {
        DeadFlowContext dfc1 = eg1.deadContext;
        DeadFlowContext dfc2 = eg2.deadContext;
        if (dfc1.isForwardDeadFlow() == dfc2.isForwardDeadFlow()) {
            return 0;
        }
        return dfc1.isForwardDeadFlow() ? 1 : -1;
    }

    private static int compareFinallyContext(EdgeGuide eg1, EdgeGuide eg2) {
        FinallyFlowContext ffc1 = eg1.finallyContext;
        FinallyFlowContext ffc2 = eg2.finallyContext;
        if (ffc1.finallyBlockContexts.isEmpty() == ffc2.finallyBlockContexts.isEmpty()) {
            return 0;
        }
        return ffc1.finallyBlockContexts.isEmpty() ? -1 : 1;
    }

    private static int compareASTPosition(EdgeGuide eg1, EdgeGuide eg2) {
        Node nextNode1 = eg1.getNextNode();
        Node nextNode2 = eg2.getNextNode();
        int p2 = nextNode2.astPosition;
        int p1 = nextNode1.astPosition;
        boolean isForward = eg1.edgeProvider.isForward();
        int posDiff = isForward ? p1 - p2 : p2 - p1;
        return posDiff;
    }

    public String toString() {
        String s = "";
        for (EdgeGuide eg : this.edgeGuideQueue) {
            s = String.valueOf(s) + this.getEdgeString(eg) + "\n";
        }
        return s;
    }

    public String getEdgeString(EdgeGuide eg) {
        String egs = "[";
        egs = String.valueOf(egs) + eg.getNextNode().astPosition;
        egs = String.valueOf(egs) + (eg.deadContext.isForwardDeadFlow() ? " D " : " d ");
        egs = String.valueOf(egs) + (eg.finallyContext.finallyBlockContexts.isEmpty() ? "f" : "F");
        egs = String.valueOf(egs) + "] " + eg.getEdge().toString();
        return egs;
    }
}

