/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.debug;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension4;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.debug.BreakpointRulerAction;
import org.eclipse.wst.sse.ui.internal.extension.BreakpointProviderBuilder;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IBreakpointProvider;
import org.osgi.framework.Bundle;

public class ToggleBreakpointAction
extends BreakpointRulerAction {
    IAction fFallbackAction;

    public ToggleBreakpointAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        super(editor, rulerInfo);
        this.setText(SSEUIMessages.ToggleBreakpointAction_0);
    }

    public ToggleBreakpointAction(ITextEditor editor, IVerticalRulerInfo rulerInfo, IAction fallbackAction) {
        this(editor, rulerInfo);
        this.fFallbackAction = fallbackAction;
    }

    protected boolean createBreakpoints(int lineNumber) {
        ITextEditor editor = this.getTextEditor();
        IEditorInput input = editor.getEditorInput();
        IDocument document = editor.getDocumentProvider().getDocument((Object)input);
        if (document == null) {
            return false;
        }
        String contentType = this.getContentType(document);
        IBreakpointProvider[] providers = BreakpointProviderBuilder.getInstance().getBreakpointProviders((IEditorPart)editor, contentType, ToggleBreakpointAction.getFileExtension(input));
        int pos = -1;
        ISourceEditingTextTools tools = (ISourceEditingTextTools)editor.getAdapter(ISourceEditingTextTools.class);
        if (tools != null) {
            pos = tools.getCaretOffset();
        }
        int n = providers.length;
        ArrayList<IStatus> errors = new ArrayList<IStatus>(0);
        int i = 0;
        while (i < n) {
            try {
                IStatus status = providers[i].addBreakpoint(document, input, lineNumber, pos);
                if (status != null && !status.isOK()) {
                    errors.add(status);
                }
            }
            catch (CoreException e) {
                errors.add(e.getStatus());
            }
            catch (Exception t) {
                Logger.logException("exception while adding breakpoint", t);
            }
            ++i;
        }
        Object status = null;
        if (errors.size() > 0) {
            Shell shell = editor.getSite().getShell();
            status = errors.size() > 1 ? new MultiStatus("org.eclipse.wst.sse.ui", 0, errors.toArray(new IStatus[0]), SSEUIMessages.ManageBreakpoints_error_adding_message1, null) : (IStatus)errors.get(0);
            if (status.getSeverity() > 1 || Platform.inDebugMode() && !status.isOK()) {
                Platform.getLog((Bundle)SSEUIPlugin.getDefault().getBundle()).log(status);
            }
            if (status.getSeverity() > 1 && this.getBreakpoints(this.getMarkers()).length < 1) {
                ErrorDialog.openError((Shell)shell, (String)SSEUIMessages.ManageBreakpoints_error_adding_title1, (String)status.getMessage(), (IStatus)status);
                return false;
            }
        }
        if (!(status != null && status.getSeverity() >= 2 || this.fFallbackAction == null || this.hasMarkers())) {
            if (this.fFallbackAction instanceof ISelectionListener) {
                ((ISelectionListener)this.fFallbackAction).selectionChanged(null, null);
            }
            this.fFallbackAction.run();
        }
        return true;
    }

    protected String getContentType(IDocument document) {
        IModelManager mgr = StructuredModelManager.getModelManager();
        String contentType = null;
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension4) {
            try {
                IContentType type = ((IDocumentProviderExtension4)provider).getContentType((Object)this.fTextEditor.getEditorInput());
                if (type != null) {
                    contentType = type.getId();
                }
            }
            catch (CoreException coreException) {}
        }
        if (contentType == null) {
            IStructuredModel model = null;
            try {
                model = mgr.getExistingModelForRead(document);
                if (model != null) {
                    contentType = model.getContentTypeIdentifier();
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return contentType;
    }

    protected void removeBreakpoints(int lineNumber) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = this.getBreakpoints(this.getMarkers());
        int i = 0;
        while (i < breakpoints.length) {
            try {
                breakpointManager.removeBreakpoint(breakpoints[i], true);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
            ++i;
        }
    }

    public void run() {
        boolean doAdd;
        int lineNumber = this.fRulerInfo.getLineOfLastMouseButtonActivity() + 1;
        boolean bl = doAdd = !this.hasMarkers();
        if (doAdd) {
            this.createBreakpoints(lineNumber);
        } else {
            this.removeBreakpoints(lineNumber);
        }
    }

    public void update() {
    }

    public ImageDescriptor getImageDescriptor() {
        ImageDescriptor image = super.getImageDescriptor();
        if (image == null) {
            image = DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT");
            this.setImageDescriptor(image);
        }
        return image;
    }
}

