/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.ui.labeling;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.n4js.json.ui.internal.JsonActivator;
import org.eclipse.swt.graphics.Image;

public enum JSONImageDescriptorCache {
    INSTANCE;

    private static final String PLUGIN_ID;
    private static final String ICON_FOLDER = "icons";
    private static final LoadingCache<Optional<ImageDescriptor>, Optional<Image>> IMAGE_CACHE;

    static {
        PLUGIN_ID = JsonActivator.getInstance().getBundle().getSymbolicName();
        IMAGE_CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Optional<ImageDescriptor>, Optional<Image>>(){

            public Optional<Image> load(Optional<ImageDescriptor> key) throws Exception {
                if (key == null || !key.isPresent()) {
                    return Optional.fromNullable((Object)ImageDescriptor.getMissingImageDescriptor().createImage());
                }
                return Optional.fromNullable((Object)((ImageDescriptor)key.get()).createImage());
            }
        });
    }

    private synchronized Optional<ImageDescriptor> getImageDescriptor(ImageRef ref) {
        JsonActivator activator = JsonActivator.getInstance();
        if (activator == null) {
            return Optional.absent();
        }
        ImageRegistry registry = activator.getImageRegistry();
        if (registry == null) {
            return Optional.absent();
        }
        ImageDescriptor descriptor = registry.getDescriptor(ref.fileName);
        if (descriptor == null) {
            String imageFilePath = ICON_FOLDER + File.separator + ref.fileName;
            descriptor = ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)imageFilePath).orElse(null);
            registry.put(ref.fileName, descriptor);
        }
        return Optional.fromNullable((Object)descriptor);
    }

    public static enum ImageRef {
        JSON_OBJECT("json_object.png"),
        JSON_ARRAY("json_array.png"),
        JSON_VALUE_PAIR("public_co.png"),
        JSON_VALUE("json_value.png");

        private static final Logger LOGGER;
        private final String fileName;

        static {
            LOGGER = Logger.getLogger(ImageRef.class);
        }

        private ImageRef(String fileName) {
            this.fileName = fileName;
        }

        public Optional<ImageDescriptor> asImageDescriptor() {
            return INSTANCE.getImageDescriptor(this);
        }

        public Optional<Image> asImage() {
            try {
                return (Optional)IMAGE_CACHE.get(this.asImageDescriptor());
            }
            catch (ExecutionException e) {
                LOGGER.error((Object)("Error while trying to get image from image descriptor of: " + (Object)((Object)this)));
                return Optional.absent();
            }
        }
    }
}

