/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.console;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.n4js.ui.console.ConsoleMessages;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.TextConsole;

public class N4JSStackTraceConsole
extends TextConsole {
    public static final String CONSOLE_TYPE = "n4jsStackTraceConsole";
    private static final String FILE_NAME = String.valueOf(N4JSActivator.getInstance().getStateLocation().toOSString()) + File.separator + "n4jsStackTraceConsole" + ".txt";
    private final N4JSStackTraceConsolePartitioner partitioner = new N4JSStackTraceConsolePartitioner();

    public N4JSStackTraceConsole() {
        super(ConsoleMessages.msgN4JSStackTraceConsole(), CONSOLE_TYPE, null, true);
        Font font = JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont");
        this.setFont(font);
        this.partitioner.connect(this.getDocument());
    }

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public void initializeDocument() {
        File file = new File(FILE_NAME);
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file));){
                    int len = (int)file.length();
                    byte[] b = new byte[len];
                    int read = 0;
                    while (read < len) {
                        read += ((InputStream)fin).read(b);
                    }
                    this.getDocument().set(new String(b));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        } else {
            this.getDocument().set(ConsoleMessages.msgConsoleCallToAction());
        }
    }

    public void saveDocument() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileOutputStream fout = new FileOutputStream(FILE_NAME);){
                IDocument document = this.getDocument();
                if (document != null) {
                    if (document.getLength() > 0) {
                        String contents = document.get();
                        fout.write(contents.getBytes());
                    } else {
                        File file = new File(FILE_NAME);
                        file.delete();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class N4JSStackTraceConsolePartitioner
    extends FastPartitioner
    implements IConsoleDocumentPartitioner {
        public N4JSStackTraceConsolePartitioner() {
            super((IPartitionTokenScanner)new RuleBasedPartitionScanner(), null);
            N4JSStackTraceConsole.this.getDocument().setDocumentPartitioner((IDocumentPartitioner)this);
        }

        public boolean isReadOnly(int offset) {
            return false;
        }

        public StyleRange[] getStyleRanges(int offset, int length) {
            return null;
        }
    }
}

