/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;

public final class ExternalLibraryHelper {
    public static final String NPM_CATEGORY = "node_modules";
    public static final List<String> CATEGORY_SHADOWING_ORDER = ImmutableList.builder().add((Object)"node_modules").build();

    public boolean isExternalProjectDirectory(SafeURI<?> projectDirectory) {
        return projectDirectory instanceof FileURI && projectDirectory.isProjectRootDirectory();
    }

    public boolean isScopeDirectory(File scopeDirectory) {
        String name = scopeDirectory.getName();
        return name.startsWith("@") && ProjectDescriptionUtils.isValidScopeName(name);
    }

    public static List<FileURI> sortByShadowing(Collection<FileURI> locations) {
        HashMap<String, FileURI> knownLocations = new HashMap<String, FileURI>();
        LinkedList<FileURI> unknownLocations = new LinkedList<FileURI>();
        for (FileURI location : locations) {
            String locStr = location.toString();
            locStr = locStr.endsWith("/") ? locStr.substring(0, locStr.length() - 1) : locStr;
            boolean locationFound = false;
            for (String knownLocation : CATEGORY_SHADOWING_ORDER) {
                if (!locStr.endsWith(knownLocation) || knownLocations.containsKey(knownLocation)) continue;
                knownLocations.put(knownLocation, location);
                locationFound = true;
            }
            if (locationFound) continue;
            unknownLocations.add(location);
        }
        LinkedList<FileURI> sortedLocations = new LinkedList<FileURI>();
        for (String knownLocation : CATEGORY_SHADOWING_ORDER) {
            FileURI location = (FileURI)knownLocations.get(knownLocation);
            if (location == null) continue;
            sortedLocations.add(location);
        }
        sortedLocations.addAll(unknownLocations);
        return sortedLocations;
    }
}

