/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xpect.Assignment;
import org.eclipse.xpect.BooleanLiteral;
import org.eclipse.xpect.ClassLiteral;
import org.eclipse.xpect.Component;
import org.eclipse.xpect.IntLiteral;
import org.eclipse.xpect.StringLiteral;
import org.eclipse.xpect.Text;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.XpectIgnore;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.XpectPackage;
import org.eclipse.xpect.XpectTest;
import org.eclipse.xpect.services.XpectGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

public class XpectSemanticSequencer
extends AbstractDelegatingSemanticSequencer {
    @Inject
    private XpectGrammarAccess grammarAccess;

    public void sequence(ISerializationContext context, EObject semanticObject) {
        EPackage epackage = semanticObject.eClass().getEPackage();
        ParserRule rule = context.getParserRule();
        Action action = context.getAssignedAction();
        Set parameters = context.getEnabledBooleanParameters();
        if (epackage == XpectPackage.eINSTANCE) {
            switch (semanticObject.eClass().getClassifierID()) {
                case 8: {
                    this.sequence_Assignment(context, (Assignment)semanticObject);
                    return;
                }
                case 13: {
                    this.sequence_Literal(context, (BooleanLiteral)semanticObject);
                    return;
                }
                case 12: {
                    this.sequence_ClassLiteral(context, (ClassLiteral)semanticObject);
                    return;
                }
                case 10: {
                    if (rule == this.grammarAccess.getValueRule() || rule == this.grammarAccess.getComponentInlineRule()) {
                        this.sequence_ComponentInline(context, (Component)semanticObject);
                        return;
                    }
                    if (rule != this.grammarAccess.getComponentLongRule()) break;
                    this.sequence_ComponentLong(context, (Component)semanticObject);
                    return;
                }
                case 14: {
                    this.sequence_Literal(context, (IntLiteral)semanticObject);
                    return;
                }
                case 15: {
                    this.sequence_Literal(context, (StringLiteral)semanticObject);
                    return;
                }
                case 6: {
                    this.sequence_Text(context, (Text)semanticObject);
                    return;
                }
                case 0: {
                    this.sequence_XpectFile(context, (XpectFile)semanticObject);
                    return;
                }
                case 2: {
                    this.sequence_XpectIgnore(context, (XpectIgnore)semanticObject);
                    return;
                }
                case 3: {
                    this.sequence_Lexicalspace_Invocation(context, (XpectInvocation)semanticObject);
                    return;
                }
                case 1: {
                    this.sequence_Lexicalspace_Setup(context, (XpectTest)semanticObject);
                    return;
                }
            }
        }
        if (this.errorAcceptor != null) {
            this.errorAcceptor.accept(this.diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
        }
    }

    protected void sequence_Assignment(ISerializationContext context, Assignment semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_ClassLiteral(ISerializationContext context, ClassLiteral semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)XpectPackage.Literals.CLASS_LITERAL__TYPE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)XpectPackage.Literals.CLASS_LITERAL__TYPE));
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getClassLiteralAccess().getTypeJvmDeclaredTypeQualifiedNameParserRuleCall_1_0_1(), (Object)semanticObject.getType());
        feeder.finish();
    }

    protected void sequence_ComponentInline(ISerializationContext context, Component semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_ComponentLong(ISerializationContext context, Component semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Lexicalspace_Invocation(ISerializationContext context, XpectInvocation semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Lexicalspace_Setup(ISerializationContext context, XpectTest semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Literal(ISerializationContext context, BooleanLiteral semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_Literal(ISerializationContext context, IntLiteral semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)XpectPackage.Literals.INT_LITERAL__VALUE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)XpectPackage.Literals.INT_LITERAL__VALUE));
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getLiteralAccess().getValueINTTerminalRuleCall_1_1_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_Literal(ISerializationContext context, StringLiteral semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)XpectPackage.Literals.STRING_LITERAL__VALUE) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)XpectPackage.Literals.STRING_LITERAL__VALUE));
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getLiteralAccess().getValueSTRINGTerminalRuleCall_2_1_0(), (Object)semanticObject.getValue());
        feeder.finish();
    }

    protected void sequence_Text(ISerializationContext context, Text semanticObject) {
        if (this.errorAcceptor != null && this.transientValues.isValueTransient((EObject)semanticObject, (EStructuralFeature)XpectPackage.Literals.TEXT__TEXT) == ITransientValueService.ValueTransient.YES) {
            this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)XpectPackage.Literals.TEXT__TEXT));
        }
        SequenceFeeder feeder = this.createSequencerFeeder(context, semanticObject);
        feeder.accept(this.grammarAccess.getTextAccess().getTextAnyTextParserRuleCall_0(), (Object)semanticObject.getText());
        feeder.finish();
    }

    protected void sequence_XpectFile(ISerializationContext context, XpectFile semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }

    protected void sequence_XpectIgnore(ISerializationContext context, XpectIgnore semanticObject) {
        this.genericSequencer.createSequence(context, (EObject)semanticObject);
    }
}

