/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli;

import com.google.common.base.Strings;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum N4jscExitCode {
    SUCCESS(0, ""),
    ERROR_UNEXPECTED(1, "Unexpected error"),
    NOT_IMPLEMENTED(2, "Feature is not implemented"),
    CMD_LINE_PARSE_INVALID(10, "Invalid command line string"),
    ARGUMENT_GOAL_INVALID(11, "Invalid goal"),
    ARGUMENT_FILES_INVALID(12, "Invalid file(s)"),
    OPTION_INVALID(13, "Invalid option"),
    TEST_CATALOG_ASSEMBLATION_ERROR(110, "Error when assembling the test catalog");

    private static final Map<Integer, N4jscExitCode> lookup;
    private final String explanation;
    private final int code;

    static {
        lookup = new HashMap<Integer, N4jscExitCode>();
        for (N4jscExitCode ec : EnumSet.allOf(N4jscExitCode.class)) {
            lookup.put(ec.getExitCodeValue(), ec);
        }
    }

    private N4jscExitCode(int code, String explanation) {
        this.code = code;
        this.explanation = explanation;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public int getExitCodeValue() {
        return this.code;
    }

    public static N4jscExitCode fromInt(int code) {
        return lookup.get(code);
    }

    public String toUserString() {
        String s = this == SUCCESS ? "SUCCESS" : "ERROR-" + this.code;
        s = String.valueOf(s) + (Strings.isNullOrEmpty((String)this.explanation) ? "" : " (" + this.explanation + ")");
        return s;
    }
}

