/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli;

import com.google.inject.Injector;
import org.eclipse.n4js.cli.N4jscBackend;
import org.eclipse.n4js.cli.N4jscFactory;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.cli.compiler.N4jscLanguageClient;
import org.eclipse.n4js.cli.helper.N4jscTestCallback;
import org.eclipse.xtext.testing.GlobalRegistries;

public class N4jscTestFactory
extends N4jscFactory {
    private static Injector injector;
    private final boolean deactivateBackend;

    public static void set() {
        N4jscFactory.INSTANCE = new N4jscTestFactory(false);
    }

    public static void setAndDeactivateBackend() {
        N4jscFactory.INSTANCE = new N4jscTestFactory(true);
    }

    public static void unset() {
        N4jscFactory.INSTANCE = new N4jscFactory();
    }

    N4jscTestFactory(boolean deactivateBackend) {
        this.deactivateBackend = deactivateBackend;
    }

    N4jscBackend internalCreateBackend() throws Exception {
        if (this.deactivateBackend) {
            return new NoopBackend();
        }
        return super.internalCreateBackend();
    }

    Injector internalCreateInjector() {
        GlobalRegistries.clearGlobalRegistries();
        injector = super.internalCreateInjector();
        return injector;
    }

    public static Injector getLastCreatedInjector() {
        return injector;
    }

    N4jscLanguageClient internalGetLanguageClient(Injector pInjector) {
        N4jscLanguageClient callback = (N4jscLanguageClient)pInjector.getInstance(N4jscTestCallback.class);
        return callback;
    }

    static class NoopBackend
    extends N4jscBackend {
        NoopBackend() {
        }

        public void goalApi(N4jscOptions options) {
        }

        public void goalClean(N4jscOptions options) {
        }

        public void goalCompile(N4jscOptions options) {
        }

        public void goalLsp(N4jscOptions options) {
        }

        public void goalWatch(N4jscOptions options) {
        }
    }
}

