/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.junit.Assert;

public class SystemOutRedirecter {
    private PrintStream oldSystemOut;
    private PrintStream oldSystemErr;
    private ByteArrayOutputStream redirectOut;
    private ByteArrayOutputStream redirectErr;

    public final void setRedirections() {
        this.oldSystemOut = System.out;
        this.oldSystemErr = System.err;
        this.redirectOut = new ByteArrayOutputStream();
        this.redirectErr = new ByteArrayOutputStream();
        try {
            PrintStream psOut = new PrintStream((OutputStream)this.redirectOut, true, "UTF-8");
            PrintStream psErr = new PrintStream((OutputStream)this.redirectErr, true, "UTF-8");
            System.setOut(psOut);
            System.setErr(psErr);
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)"Could not redirect output streams");
        }
    }

    public final void unsetRedirections() {
        System.out.flush();
        System.err.flush();
        System.setOut(this.oldSystemOut);
        System.setErr(this.oldSystemErr);
    }

    public String getSystemOut() {
        try {
            System.out.flush();
            String output = this.redirectOut.toString("UTF-8");
            return output;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getSystemErr() {
        try {
            System.err.flush();
            String output = this.redirectErr.toString("UTF-8");
            return output;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }
}

