/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.scoping;

import com.google.inject.Inject;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.SimpleAttributeResolver;

public class N4TSQualifiedNameProvider
extends IQualifiedNameProvider.AbstractImpl {
    public static String GLOBAL_NAMESPACE_SEGMENT = "#";
    public static String POLYFILL_SEGMENT = "!POLY";
    public static String MODULE_POLYFILL_SEGMENT = "!MPOLY";
    @Inject
    protected IQualifiedNameConverter converter;

    public QualifiedName getFullyQualifiedName(EObject obj) {
        String name = (String)SimpleAttributeResolver.NAME_RESOLVER.apply(obj);
        if (name == null || name.isEmpty()) {
            return null;
        }
        return this.converter.toQualifiedName(name);
    }

    public static QualifiedName getPolyfillFQN(TClassifier tClassifier, IQualifiedNameProvider qualifiedNameProvider) {
        QualifiedName prefix = qualifiedNameProvider.getFullyQualifiedName(EcoreUtil.getRootContainer((EObject)tClassifier));
        if ("n4ts".equals(tClassifier.eResource().getURI().fileExtension())) {
            prefix = N4TSQualifiedNameProvider.append(prefix, GLOBAL_NAMESPACE_SEGMENT);
        }
        prefix = N4TSQualifiedNameProvider.append(prefix, POLYFILL_SEGMENT);
        return N4TSQualifiedNameProvider.append(prefix, tClassifier.getName());
    }

    public static QualifiedName getStaticPolyfillFQN(TClassifier tClassifier, IQualifiedNameProvider qualifiedNameProvider) {
        QualifiedName prefix = qualifiedNameProvider.getFullyQualifiedName(EcoreUtil.getRootContainer((EObject)tClassifier));
        prefix = N4TSQualifiedNameProvider.prepend(MODULE_POLYFILL_SEGMENT, prefix);
        prefix = N4TSQualifiedNameProvider.append(prefix, POLYFILL_SEGMENT);
        return N4TSQualifiedNameProvider.append(prefix, tClassifier.getName());
    }

    public static QualifiedName getStaticPolyfillFQN(TModule tModule, IQualifiedNameProvider qualifiedNameProvider) {
        QualifiedName prefix = qualifiedNameProvider.getFullyQualifiedName(EcoreUtil.getRootContainer((EObject)tModule));
        return N4TSQualifiedNameProvider.toStaticPolyfillFQN(prefix).orElse(null);
    }

    protected static QualifiedName append(QualifiedName prefix, String segment) {
        if (segment == null) {
            return null;
        }
        if (prefix == null) {
            return QualifiedName.create((String)segment);
        }
        return prefix.append(segment);
    }

    protected static QualifiedName prepend(String segment, QualifiedName suffix) {
        if (segment == null) {
            return suffix;
        }
        QualifiedName qn = QualifiedName.create((String)segment);
        if (suffix != null) {
            qn = qn.append(suffix);
        }
        return qn;
    }

    public static boolean isPolyfill(QualifiedName name) {
        if (name == null || name.getSegmentCount() < 2) {
            return false;
        }
        int polyModuleOffest = N4TSQualifiedNameProvider.isModulePolyfill(name) ? 1 : 0;
        return POLYFILL_SEGMENT.equals(name.getSegment(name.getSegmentCount() - (2 + polyModuleOffest)));
    }

    public static boolean isModulePolyfill(QualifiedName name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return MODULE_POLYFILL_SEGMENT.equals(name.getFirstSegment());
    }

    public static Optional<QualifiedName> toStaticPolyfillFQN(QualifiedName name) {
        if (name != null && !name.isEmpty() && !MODULE_POLYFILL_SEGMENT.equals(name.getFirstSegment())) {
            return Optional.of(N4TSQualifiedNameProvider.prepend(MODULE_POLYFILL_SEGMENT, name));
        }
        return Optional.empty();
    }
}

