/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.binaries.BinariesPreferenceStore;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.utils.OSInfo;
import org.eclipse.xtext.xbase.lib.Pair;

public abstract class Binary {
    @Inject
    protected BinariesPreferenceStore preferenceStore;
    String PATH = "PATH";

    public abstract String getId();

    public abstract String getLabel();

    public String getDescription() {
        return null;
    }

    public abstract VersionNumber getMinimumVersion();

    public String getBinaryAbsolutePath() {
        return String.valueOf(this.getBinaryDirectory()) + File.separator + this.getBinaryFileName();
    }

    public abstract String getBinaryDirectory();

    public abstract String getBinaryFileName();

    public abstract String getVersionArgument();

    public Binary getParent() {
        return null;
    }

    public Iterable<Binary> getChildren() {
        return Collections.emptyList();
    }

    public Map<String, String> updateEnvironment(Map<String, String> environment) {
        String additionalPath = this.getBinaryDirectory();
        String actualPathPropertyName = this.findActualPropertyNameOrDefault(environment, this.PATH);
        String newValue = environment.containsKey(actualPathPropertyName) ? String.valueOf(environment.get(actualPathPropertyName)) + File.pathSeparator + additionalPath : additionalPath;
        environment.put(actualPathPropertyName, newValue);
        return environment;
    }

    protected String findActualPropertyNameOrDefault(Map<String, String> environment, String defaultName) {
        if (environment.containsKey(defaultName)) {
            return defaultName;
        }
        if (OSInfo.isWindows()) {
            if (System.getenv(defaultName) == null) {
                return defaultName;
            }
            for (String prop : environment.keySet()) {
                if (!defaultName.equalsIgnoreCase(prop)) continue;
                return prop;
            }
        }
        return defaultName;
    }

    public URI getUserConfiguredLocation() {
        return this.preferenceStore.getPath(this);
    }

    public abstract IStatus validate();

    public Optional<String[]> getCacheCleanCommand() {
        return Optional.absent();
    }

    public boolean canInstallNpmPackages() {
        return false;
    }

    public String getNpmInstallCommand(boolean readPackagesFromPackageJson) {
        throw new UnsupportedOperationException("(un-)installation of npm packages not supported by this tool");
    }

    public String getNpmUninstallCommand() {
        throw new UnsupportedOperationException("(un-)installation of npm packages not supported by this tool");
    }

    public Optional<Pair<String, String>> getNpmSaveOptions() {
        throw new UnsupportedOperationException("(un-)installation of npm packages not supported by this tool");
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Binary)) {
            return false;
        }
        Binary other = (Binary)obj;
        return Objects.equals(this.getId(), other.getId());
    }
}

