/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.projectModel.lsp.ex;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.lsp.ex.IProjectConfigEx;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.xtext.workspace.ISourceFolder;

public interface ISourceFolderEx
extends ISourceFolder {
    public IProjectConfigEx getProject();

    default public boolean contains(URI uri) {
        URI path = this.getPath();
        path = path.hasTrailingPathSeparator() ? path : path.appendSegment("");
        uri = uri.hasTrailingPathSeparator() ? uri : uri.appendSegment("");
        return uri.toFileString().startsWith(uri.toFileString());
    }

    default public List<URI> getAllResources() {
        final LinkedList<URI> uris = new LinkedList<URI>();
        Path srcPath = Paths.get(this.getPath().toFileString(), new String[0]);
        SimpleFileVisitor<Path> fv = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                URI uri = URIUtils.toFileUri((Path)file);
                uris.add(uri);
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(srcPath, (FileVisitor<? super Path>)fv);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return uris;
    }
}

