/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor.syntaxcoloring;

import com.google.common.base.Stopwatch;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.n4js.parser.AntlrStreamWithToString;
import org.eclipse.n4js.parser.LazyTokenStream;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ui.editor.syntaxcoloring.InternalHighlightingParser;
import org.eclipse.n4js.ui.editor.syntaxcoloring.InternalN4JSParser;
import org.eclipse.n4js.ui.editor.syntaxcoloring.TokenTypeRewriter;
import org.eclipse.xtext.parser.ParseException;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.parser.antlr.IUnorderedGroupHelper;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;

@Singleton
public class HighlightingParser {
    private static final Logger LOGGER = Logger.getLogger(HighlightingParser.class);
    @Inject
    private ITokenDefProvider tokenDefProvider;
    @Inject
    private Provider<IUnorderedGroupHelper> unorderedGroupHelper;
    @Inject
    @Named(value="org.eclipse.xtext.parser.antlr.Lexer.RUNTIME")
    private Provider<Lexer> lexerProvider;
    @Inject
    private N4JSGrammarAccess grammarAccess;
    @Inject
    private TokenTypeRewriter rewriter;

    private void setInitialHiddenTokens(XtextTokenStream tokenStream) {
        tokenStream.setInitialHiddenTokens(new String[]{InternalN4JSParser.tokenNames[152], InternalN4JSParser.tokenNames[148], InternalN4JSParser.tokenNames[149], InternalN4JSParser.tokenNames[150]});
    }

    protected InternalN4JSParser createParser(LazyTokenStream stream) {
        return new InternalHighlightingParser((TokenStream)stream, this.getGrammarAccess(), this.getRewriter());
    }

    protected N4JSGrammarAccess getGrammarAccess() {
        return this.grammarAccess;
    }

    protected TokenTypeRewriter getRewriter() {
        return this.rewriter;
    }

    public List<Token> getTokens(Reader reader) {
        try {
            return this.doParse((CharStream)new AntlrStreamWithToString(reader));
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }

    public List<Token> getTokens(CharSequence input) {
        return this.getTokens(new StringReader(input.toString()));
    }

    private List<Token> doParse(CharStream in) {
        TokenSource tokenSource = this.createLexer(in);
        LazyTokenStream tokenStream = this.createTokenStream(tokenSource);
        this.setInitialHiddenTokens((XtextTokenStream)tokenStream);
        InternalN4JSParser parser = this.createParser(tokenStream);
        IUnorderedGroupHelper helper = (IUnorderedGroupHelper)this.unorderedGroupHelper.get();
        if (!(helper instanceof IUnorderedGroupHelper.Null)) {
            throw new IllegalStateException("Unexpected usage of unordered groups.");
        }
        Stopwatch stopwatch = null;
        boolean debug = LOGGER.isDebugEnabled();
        if (debug) {
            stopwatch = Stopwatch.createStarted();
        }
        try {
            List result;
            parser.entryRuleScript();
            while (tokenStream.LT(1) != Token.EOF_TOKEN) {
                tokenStream.consume();
            }
            List list = result = tokenStream.getTokens();
            return list;
        }
        catch (Exception re) {
            throw new ParseException(re.getMessage(), re);
        }
        finally {
            if (debug) {
                assert (stopwatch != null);
                long elapsed = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
                if (elapsed > 5L) {
                    LOGGER.warn((Object)("Coloring parser took: " + elapsed));
                }
            }
        }
    }

    protected TokenSource createLexer(CharStream stream) {
        Lexer lexer = (Lexer)this.lexerProvider.get();
        lexer.setCharStream(stream);
        return lexer;
    }

    private LazyTokenStream createTokenStream(TokenSource tokenSource) {
        return new LazyTokenStream(tokenSource, this.tokenDefProvider);
    }
}

