/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.project;

import java.util.function.Consumer;
import org.eclipse.n4js.packagejson.PackageJsonBuilder;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectDescription.SourceContainerType;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.ui.wizard.project.N4JSProjectInfo;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.xtend2.lib.StringConcatenation;

public class N4JSNewProjectFileTemplates {
    public static CharSequence getSourceFileWithGreeterClass(String projectName, String safeProjectName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("export class GreeterFor_");
        _builder.append(safeProjectName);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public greet() {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("console.log(\"Hello World from '");
        _builder.append(projectName, "        ");
        _builder.append("'!\");");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("var greeter = new GreeterFor_");
        _builder.append(safeProjectName);
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("greeter.greet();");
        _builder.newLine();
        _builder.append("//right click this module and select \"Run As -> Launch in Node.js\" to see");
        _builder.newLine();
        _builder.append("//\"Hello World from '");
        _builder.append(projectName);
        _builder.append("'!\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    public static CharSequence getSourceFileWithTestGreeter(String safeProjectName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("import { Assert } from \"org/eclipse/n4js/mangelhaft/assert/Assert\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("export public class Test_");
        _builder.append(safeProjectName);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Test");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("testPass() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("Assert.isTrue(true, \"Testing works!\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Test");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("testFail() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Assert.fail(\"Test failed.\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("//right click this module and select \"Run As -> Test in Node.js\" to see the test results");
        _builder.newLine();
        return _builder;
    }

    public static String getProjectDescriptionContents(N4JSProjectInfo projectInfo) {
        boolean _equals_1;
        String projectName = ProjectDescriptionUtils.convertEclipseProjectNameToN4JSProjectName((String)projectInfo.getProjectName());
        PackageJsonBuilder builder = PackageJsonBuilder.newBuilder().withName(projectName).withVersion(PackageJsonProperties.VERSION.defaultValue).withType(projectInfo.getProjectType()).withOutput(projectInfo.getOutputFolder()).withVendorId(projectInfo.getVendorId());
        Consumer<String> _function = sourceFolder -> builder.withSourceContainer(SourceContainerType.SOURCE, sourceFolder);
        projectInfo.getSourceFolders().forEach(_function);
        Consumer<String> _function_1 = sourceFolder -> builder.withSourceContainer(SourceContainerType.EXTERNAL, sourceFolder);
        projectInfo.getExternalSourceFolders().forEach(_function_1);
        Consumer<String> _function_2 = sourceFolder -> builder.withSourceContainer(SourceContainerType.TEST, sourceFolder);
        projectInfo.getTestSourceFolders().forEach(_function_2);
        boolean _equals = ProjectType.LIBRARY.equals((Object)projectInfo.getProjectType());
        if (_equals) {
            boolean _tripleNotEquals;
            String _implementationId = projectInfo.getImplementationId();
            boolean bl = _tripleNotEquals = _implementationId != null;
            if (_tripleNotEquals) {
                builder.withImplementationId(projectInfo.getImplementationId());
            }
            Consumer<String> _function_3 = p -> builder.withImplementedProject(p);
            projectInfo.getImplementedProjects().forEach(_function_3);
        }
        if (_equals_1 = ProjectType.TEST.equals((Object)projectInfo.getProjectType())) {
            Consumer<String> _function_4 = p -> builder.withTestedProject(p);
            projectInfo.getTestedProjects().forEach(_function_4);
        }
        Consumer<String> _function_5 = dep -> {
            N4JSProjectName _n4JSProjectName = new N4JSProjectName(dep);
            builder.withDependency(_n4JSProjectName);
        };
        projectInfo.getProjectDependencies().forEach(_function_5);
        Consumer<String> _function_6 = dep -> {
            N4JSProjectName _n4JSProjectName = new N4JSProjectName(dep);
            builder.withDevDependency(_n4JSProjectName);
        };
        projectInfo.getProjectDevDependencies().forEach(_function_6);
        return builder.build();
    }
}

