/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.builder;

import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.shared.Access;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;
import org.eclipse.xtext.util.EmfFormatter;
import org.junit.Assert;

public class BuilderUtil {
    public static String print(ImmutableList<IResourceDescription.Delta> deltas) {
        int i = 1;
        String buff = "Deltas : \n";
        for (IResourceDescription.Delta delta : deltas) {
            buff = String.valueOf(buff) + "Delta " + i + "[" + delta.getUri() + "]: {\n";
            buff = String.valueOf(buff) + " old : " + BuilderUtil.toString(delta.getOld()) + "\n";
            buff = String.valueOf(buff) + " new : " + BuilderUtil.toString(delta.getNew()) + "\n";
            buff = String.valueOf(buff) + "}\n\n";
            ++i;
        }
        return buff;
    }

    public static String toString(IResourceDescription desc) {
        if (desc == null) {
            return "null";
        }
        return EmfFormatter.objToStr((Object)desc, (EStructuralFeature[])new EStructuralFeature[0]);
    }

    public static String toString(IResourceDescriptions index) {
        StringBuffer buff = new StringBuffer();
        for (IResourceDescription desc : index.getAllResourceDescriptions()) {
            buff.append(EmfFormatter.objToStr((Object)desc, (EStructuralFeature[])new EStructuralFeature[0]));
        }
        return buff.toString();
    }

    public static boolean indexContainsElement(String fileUri, String eObjectName) {
        URI uri;
        IBuilderState descriptions = BuilderUtil.getBuilderState();
        IResourceDescription description = descriptions.getResourceDescription(uri = URI.createURI((String)("platform:/resource" + fileUri)));
        if (description != null) {
            return description.getExportedObjects(EcorePackage.Literals.EOBJECT, QualifiedName.create((String)eObjectName), false).iterator().hasNext();
        }
        return false;
    }

    public static IBuilderState getBuilderState() {
        return (IBuilderState)Access.getIBuilderState().get();
    }

    public static int countResourcesInIndex() {
        return Iterables.size(BuilderUtil.getAllResourceDescriptions());
    }

    public static Iterable<IResourceDescription> getAllResourceDescriptions() {
        return BuilderUtil.getBuilderState().getAllResourceDescriptions();
    }

    public static String getAllResourceDescriptionsAsString() {
        return Joiner.on((String)",\n").join((Iterable)FluentIterable.from(BuilderUtil.getAllResourceDescriptions()).transform(d -> d.getURI()));
    }

    public static void assertNumberOfMarkers(IFile file, int numberOfMarkers) throws CoreException {
        IMarker[] markers = file.findMarkers("org.eclipse.emf.ecore.diagnostic", true, 1);
        Assert.assertEquals((String)IResourcesSetupUtil.printMarker((IMarker[])markers), (long)numberOfMarkers, (long)markers.length);
    }

    public static Set<IReferenceDescription> getIncomingReferences(URI uri) {
        HashSet desc = Sets.newHashSet();
        Iterable<IResourceDescription> descriptions = BuilderUtil.getAllResourceDescriptions();
        for (IResourceDescription res : descriptions) {
            Iterable descriptions2 = res.getReferenceDescriptions();
            for (IReferenceDescription ref : descriptions2) {
                if (uri.hasFragment()) {
                    if (!ref.getTargetEObjectUri().equals(uri)) continue;
                    desc.add(ref);
                    continue;
                }
                if (!ref.getTargetEObjectUri().trimFragment().equals(uri.trimFragment())) continue;
                desc.add(ref);
            }
        }
        return desc;
    }

    public static Set<IReferenceDescription> getContainedReferences(URI uri) {
        HashSet desc = Sets.newHashSet();
        Iterable<IResourceDescription> descriptions = BuilderUtil.getAllResourceDescriptions();
        for (IResourceDescription res : descriptions) {
            Iterable descriptions2 = res.getReferenceDescriptions();
            for (IReferenceDescription ref : descriptions2) {
                if (uri.hasFragment()) {
                    if (!ref.getSourceEObjectUri().equals(uri)) continue;
                    desc.add(ref);
                    continue;
                }
                if (!ref.getSourceEObjectUri().trimFragment().equals(uri.trimFragment())) continue;
                desc.add(ref);
            }
        }
        return desc;
    }
}

