/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.util;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class IFileUtil {
    public static IFile create(IContainer container, URI localURI, InputStream inputStream) {
        return IFileUtil.createFile(IFileUtil.findFolder(container, localURI), localURI.lastSegment(), inputStream);
    }

    public static IFile createFile(IContainer container, String name, InputStream inputStream) {
        IFile file = container.getFile((IPath)new Path(name));
        try {
            try {
                file.create(inputStream, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                Closeables.close((Closeable)inputStream, (boolean)true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return file;
    }

    public static IFolder createFolder(IContainer container, String name) {
        IFolder file = container.getFolder((IPath)new Path(name));
        try {
            file.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    public static IContainer findFolder(IContainer container, URI localURI) {
        Path path;
        IFolder folder;
        if (localURI.segmentCount() > 1 && !(folder = container.getFolder((IPath)(path = new Path(localURI.trimSegments(1).toString())))).exists()) {
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                return folder;
            }
            catch (CoreException e) {
                throw new RuntimeException();
            }
        }
        return container;
    }
}

