/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor.syntaxcoloring;

import com.google.inject.Singleton;
import org.eclipse.xtext.ui.editor.model.TerminalsTokenTypeToPartitionMapper;

@Singleton
public class TokenTypeToPartitionMapper
extends TerminalsTokenTypeToPartitionMapper {
    public static final String JS_DOC_PARTITION = "__jsdoc";
    public static final String REG_EX_PARTITION = "__regex";
    public static final String TEMPLATE_LITERAL_PARTITION = "__template";
    public static final String[] SUPPORTED_PARTITION_TYPES = new String[]{"__comment", "__jsdoc", "__sl_comment", "__regex", "__string", "__template", "__dftl_partition_content_type"};

    public String getPartitionType(int antlrTokenType) {
        if (antlrTokenType == 171) {
            return JS_DOC_PARTITION;
        }
        if (antlrTokenType >= 167) {
            return "__dftl_partition_content_type";
        }
        return super.getPartitionType(antlrTokenType);
    }

    protected String calculateId(String tokenName, int tokenType) {
        switch (tokenType) {
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: {
                return TEMPLATE_LITERAL_PARTITION;
            }
            case 134: 
            case 135: {
                return REG_EX_PARTITION;
            }
        }
        return super.calculateId(tokenName, tokenType);
    }

    public String[] getSupportedPartitionTypes() {
        return SUPPORTED_PARTITION_TYPES;
    }

    public boolean isMultiLineComment(String partitionType) {
        return super.isMultiLineComment(partitionType) || JS_DOC_PARTITION.equals(partitionType);
    }
}

