/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.compiler;

import com.google.inject.Injector;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.n4js.cli.N4jscException;
import org.eclipse.n4js.cli.N4jscExitCode;
import org.eclipse.n4js.cli.N4jscFactory;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.cli.compiler.N4jscLanguageClient;
import org.eclipse.n4js.ide.server.N4JSLanguageServerImpl;
import org.eclipse.n4js.ide.server.N4JSWorkspaceManager;

public class N4jscCompiler {
    private final N4jscOptions options;
    private final Injector injector = N4jscFactory.createInjector();
    private final N4JSLanguageServerImpl languageServer;
    private final N4jscLanguageClient callback;
    private final N4JSWorkspaceManager workspaceManager;

    public static void start(N4jscOptions options) throws Exception {
        N4jscCompiler compiler = new N4jscCompiler(options);
        compiler.start();
    }

    private N4jscCompiler(N4jscOptions options) {
        this.options = options;
        this.languageServer = N4jscFactory.getLanguageServer(this.injector);
        this.callback = N4jscFactory.getLanguageClient(this.injector);
        this.workspaceManager = N4jscFactory.getWorkspaceManager(this.injector);
        this.languageServer.connect((LanguageClient)this.callback);
    }

    public void start() throws Exception {
        InitializeParams params = new InitializeParams();
        List<File> srcs = this.options.getSrcFiles();
        File firstDir = null;
        for (File src : srcs) {
            if (!src.isDirectory()) continue;
            firstDir = src;
            break;
        }
        if (firstDir == null) {
            throw new N4jscException(N4jscExitCode.ERROR_UNEXPECTED, "No root directory");
        }
        params.setRootUri(firstDir.toURI().toString());
        this.languageServer.initialize(params).get();
        this.warnIfNoProjectsFound();
        this.verbosePrintAllProjects();
        this.languageServer.initialized(new InitializedParams());
        this.languageServer.joinInitialized();
        this.languageServer.shutdown();
        this.languageServer.exit();
    }

    private void warnIfNoProjectsFound() {
        Set projects = this.workspaceManager.getWorkspaceConfig().getProjects();
        if (projects.isEmpty()) {
            System.out.println("No projects found at the given location: " + this.options.getSrcFiles().get(0));
        }
    }

    private void verbosePrintAllProjects() {
        Set projects;
        if (this.options.isVerbose() && !(projects = this.workspaceManager.getWorkspaceConfig().getProjects()).isEmpty()) {
            Path workspace = this.options.getSrcFiles().get(0).toPath();
            List projectNameList = projects.stream().map(p -> String.valueOf(p.getName()) + " at " + Path.of(p.getPath().toFileString(), new String[0]).relativize(workspace)).collect(Collectors.toList());
            System.out.println("Projects:");
            System.out.print("   " + String.join((CharSequence)"\n   ", projectNameList));
        }
    }
}

