/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.xtext.server.XBuildManager;
import org.eclipse.n4js.ide.xtext.server.XProjectManager;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.n4js.ide.xtext.server.build.XIncrementalBuilder;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class N4JSBuildManager
extends XBuildManager {
    private XWorkspaceManager accessibleWorkspaceManager;
    private final Multimap<ProjectDescription, URI> myDirtyFiles = LinkedHashMultimap.create();
    private final Multimap<ProjectDescription, URI> myDeletedFiles = LinkedHashMultimap.create();
    private List<IResourceDescription.Delta> myUnreportedDeltas = new ArrayList<IResourceDescription.Delta>();

    @Override
    public void setWorkspaceManager(XWorkspaceManager workspaceManager) {
        super.setWorkspaceManager(workspaceManager);
        this.accessibleWorkspaceManager = workspaceManager;
    }

    @Override
    public XBuildManager.XBuildable submit(List<URI> dirtyFiles, List<URI> deletedFiles) {
        for (URI dirtyFile : dirtyFiles) {
            if (".n4js.projectstate".equals(dirtyFile.lastSegment())) continue;
            XProjectManager projectManager = this.accessibleWorkspaceManager.getProjectManager(dirtyFile);
            ProjectDescription description = projectManager.getProjectDescription();
            this.myDeletedFiles.remove((Object)description, (Object)dirtyFile);
            this.myDirtyFiles.put((Object)description, (Object)dirtyFile);
        }
        for (URI deletedFile : deletedFiles) {
            if (".n4js.projectstate".equals(deletedFile.lastSegment())) continue;
            ProjectDescription description = this.accessibleWorkspaceManager.getProjectManager(deletedFile).getProjectDescription();
            this.myDeletedFiles.put((Object)description, (Object)deletedFile);
            this.myDirtyFiles.remove((Object)description, (Object)deletedFile);
        }
        return this::internalBuild;
    }

    @Override
    public List<IResourceDescription.Delta> doInitialBuild(List<ProjectDescription> projects, CancelIndicator indicator) {
        this.myDeletedFiles.keySet().retainAll(projects);
        this.myDirtyFiles.keySet().retainAll(projects);
        return this.internalBuild(indicator);
    }

    void enqueue(ProjectDescription description, List<URI> dirtyFiles, List<URI> deletedFiles) {
        this.myDeletedFiles.get((Object)description).removeAll(dirtyFiles);
        this.myDeletedFiles.putAll((Object)description, deletedFiles);
        this.myDirtyFiles.get((Object)description).removeAll(deletedFiles);
        this.myDirtyFiles.putAll((Object)description, dirtyFiles);
    }

    @Override
    protected void queue(Set<URI> files, Collection<URI> toRemove, Collection<URI> toAdd) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<IResourceDescription.Delta> internalBuild(CancelIndicator cancelIndicator) {
        Multimap<ProjectDescription, URI> project2dirty = this.myDirtyFiles;
        Multimap<ProjectDescription, URI> project2deleted = this.myDeletedFiles;
        Set dirtyProjects = project2dirty.keySet();
        Set deletedProjects = project2deleted.keySet();
        List<ProjectDescription> sortedDescriptions = this.sortByDependencies((Iterable<ProjectDescription>)FluentIterable.concat((Iterable)dirtyProjects, (Iterable)deletedProjects));
        for (ProjectDescription it : sortedDescriptions) {
            XProjectManager projectManager = this.accessibleWorkspaceManager.getProjectManager(it.getName());
            ArrayList<URI> projectDirty = new ArrayList<URI>(project2dirty.get((Object)it));
            ArrayList<URI> projectDeleted = new ArrayList<URI>(project2deleted.get((Object)it));
            XIncrementalBuilder.XResult partialResult = projectManager.doBuild(projectDirty, projectDeleted, this.myUnreportedDeltas, cancelIndicator);
            this.myDirtyFiles.get((Object)it).removeAll(projectDirty);
            this.myDeletedFiles.get((Object)it).removeAll(projectDeleted);
            this.mergeWithUnreportedDeltas(partialResult.getAffectedResources());
        }
        List<IResourceDescription.Delta> result = this.myUnreportedDeltas;
        this.myUnreportedDeltas = new ArrayList<IResourceDescription.Delta>();
        return result;
    }

    @Override
    protected Boolean mergeWithUnreportedDeltas(List<IResourceDescription.Delta> newDeltas) {
        if (this.myUnreportedDeltas.isEmpty()) {
            this.myUnreportedDeltas.addAll(newDeltas);
        } else {
            Map unreportedByUri = IterableExtensions.toMap(this.myUnreportedDeltas, IResourceDescription.Delta::getUri);
            for (IResourceDescription.Delta newDelta : newDeltas) {
                IResourceDescription.Delta unreportedDelta = (IResourceDescription.Delta)unreportedByUri.get(newDelta.getUri());
                if (unreportedDelta == null) {
                    unreportedByUri.put(newDelta.getUri(), newDelta);
                    continue;
                }
                unreportedByUri.remove(unreportedDelta.getUri());
                IResourceDescription _old = unreportedDelta.getOld();
                IResourceDescription _new = newDelta.getNew();
                if (_old == _new) continue;
                DefaultResourceDescriptionDelta delta = new DefaultResourceDescriptionDelta(_old, _new);
                unreportedByUri.put(delta.getUri(), delta);
            }
            this.myUnreportedDeltas = new ArrayList(unreportedByUri.values());
        }
        return null;
    }
}

