/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.n4js.ide.xtext.server.XBuildManager;
import org.eclipse.n4js.ide.xtext.server.XIProjectDescriptionFactory;
import org.eclipse.n4js.ide.xtext.server.XIWorkspaceConfigFactory;
import org.eclipse.n4js.ide.xtext.server.XProjectManager;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class XWorkspaceManager {
    private static final Logger LOG = Logger.getLogger(XWorkspaceManager.class);
    @Inject
    private Provider<XProjectManager> projectManagerProvider;
    @Inject
    private XIWorkspaceConfigFactory workspaceConfigFactory;
    @Inject
    private XIProjectDescriptionFactory projectDescriptionFactory;
    private XBuildManager buildManager;
    private final Map<String, XProjectManager> projectName2ProjectManager = new HashMap<String, XProjectManager>();
    private URI baseDir;
    private Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor;
    private IWorkspaceConfig _workspaceConfig;
    private final List<ILanguageServerAccess.IBuildListener> buildListeners = new ArrayList<ILanguageServerAccess.IBuildListener>();
    private final Map<String, ResourceDescriptionsData> fullIndex = new HashMap<String, ResourceDescriptionsData>();
    private final Map<URI, Document> openDocuments = new HashMap<URI, Document>();
    private final IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider = new IExternalContentSupport.IExternalContentProvider(){

        public IExternalContentSupport.IExternalContentProvider getActualContentProvider() {
            return this;
        }

        public String getContent(URI uri) {
            Document document = XWorkspaceManager.this.openDocuments.get(uri);
            if (document != null) {
                return document.getContents();
            }
            return null;
        }

        public boolean hasContent(URI uri) {
            return XWorkspaceManager.this.openDocuments.containsKey(uri);
        }
    };

    public void addBuildListener(ILanguageServerAccess.IBuildListener listener) {
        this.buildListeners.add(listener);
    }

    public void removeBuildListener(ILanguageServerAccess.IBuildListener listener) {
        this.buildListeners.remove(listener);
    }

    @Inject
    public void setBuildManager(XBuildManager buildManager) {
        buildManager.setWorkspaceManager(this);
        this.buildManager = buildManager;
    }

    public void initialize(URI baseDir, Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor, CancelIndicator cancelIndicator) {
        this.baseDir = baseDir;
        this.issueAcceptor = issueAcceptor;
        this.refreshWorkspaceConfig(cancelIndicator);
    }

    protected void refreshWorkspaceConfig(CancelIndicator cancelIndicator) {
        this.setWorkspaceConfig(this.workspaceConfigFactory.getWorkspaceConfig(this.baseDir));
        ArrayList<ProjectDescription> newProjects = new ArrayList<ProjectDescription>();
        Set<String> projectNames = this.projectName2ProjectManager.keySet();
        HashSet<String> remainingProjectNames = new HashSet<String>(projectNames);
        this.getWorkspaceConfig().getProjects().forEach(projectConfig -> {
            if (this.projectName2ProjectManager.containsKey(projectConfig.getName())) {
                remainingProjectNames.remove(projectConfig.getName());
            } else {
                XProjectManager projectManager = (XProjectManager)this.projectManagerProvider.get();
                ProjectDescription projectDescription = this.projectDescriptionFactory.getProjectDescription((IProjectConfig)projectConfig);
                projectManager.initialize(projectDescription, (IProjectConfig)projectConfig, this.issueAcceptor, this.openedDocumentsContentProvider, (Provider<Map<String, ResourceDescriptionsData>>)((Provider)() -> this.fullIndex), cancelIndicator);
                this.projectName2ProjectManager.put(projectDescription.getName(), projectManager);
                newProjects.add(projectDescription);
            }
        });
        for (String deletedProject : remainingProjectNames) {
            this.projectName2ProjectManager.remove(deletedProject);
            this.fullIndex.remove(deletedProject);
        }
        this.afterBuild(this.buildManager.doInitialBuild(newProjects, cancelIndicator));
    }

    protected IWorkspaceConfig getWorkspaceConfig() throws ResponseErrorException {
        if (this._workspaceConfig == null) {
            ResponseError error = new ResponseError(ResponseErrorCode.serverNotInitialized, "Workspace has not been initialized yet.", null);
            throw new ResponseErrorException(error);
        }
        return this._workspaceConfig;
    }

    protected void setWorkspaceConfig(IWorkspaceConfig workspaceConfig) {
        this._workspaceConfig = workspaceConfig;
    }

    protected void afterBuild(List<IResourceDescription.Delta> deltas) {
        for (ILanguageServerAccess.IBuildListener listener : this.buildListeners) {
            listener.afterBuild(deltas);
        }
    }

    public XBuildManager.XBuildable didChangeFiles(List<URI> dirtyFiles, List<URI> deletedFiles) {
        XBuildManager.XBuildable buildable = this.buildManager.submit(dirtyFiles, deletedFiles);
        return cancelIndicator -> {
            List<IResourceDescription.Delta> deltas = buildable.build(cancelIndicator);
            this.afterBuild(deltas);
            return deltas;
        };
    }

    public List<IResourceDescription.Delta> doBuild(List<URI> dirtyFiles, List<URI> deletedFiles, CancelIndicator cancelIndicator) {
        return this.didChangeFiles(dirtyFiles, deletedFiles).build(cancelIndicator);
    }

    public IResourceDescriptions getIndex() {
        return new ChunkedResourceDescriptions(this.fullIndex);
    }

    public URI getProjectBaseDir(URI uri) {
        IProjectConfig projectConfig = this.getWorkspaceConfig().findProjectContaining(uri);
        if (projectConfig != null) {
            return projectConfig.getPath();
        }
        return null;
    }

    public XProjectManager getProjectManager(URI uri) {
        IProjectConfig projectConfig = this.getWorkspaceConfig().findProjectContaining(uri);
        String name = null;
        if (projectConfig != null) {
            name = projectConfig.getName();
        }
        return this.getProjectManager(name);
    }

    public XProjectManager getProjectManager(String projectName) {
        return this.projectName2ProjectManager.get(projectName);
    }

    public List<XProjectManager> getProjectManagers() {
        return ImmutableList.copyOf(this.projectName2ProjectManager.values());
    }

    @Deprecated
    public List<IResourceDescription.Delta> didChange(URI uri, Integer version, Iterable<TextEdit> changes, CancelIndicator cancelIndicator) {
        return this.didChange(uri, version, changes).build(cancelIndicator);
    }

    @Deprecated
    public XBuildManager.XBuildable didChange(URI uri, Integer version, Iterable<TextEdit> changes) {
        if (!this.openDocuments.containsKey(uri)) {
            LOG.error((Object)("The document " + uri + " has not been opened."));
            return cancelIndicator -> Collections.emptyList();
        }
        Document contents = this.openDocuments.get(uri);
        this.openDocuments.put(uri, contents.applyChanges(changes));
        return this.didChangeFiles((List<URI>)ImmutableList.of((Object)uri), new ArrayList<URI>());
    }

    public XBuildManager.XBuildable didChangeTextDocumentContent(URI uri, Integer version, Iterable<TextDocumentContentChangeEvent> changes) {
        if (!this.openDocuments.containsKey(uri)) {
            LOG.error((Object)("The document " + uri + " has not been opened."));
            return cancelIndicator -> Collections.emptyList();
        }
        Document contents = this.openDocuments.get(uri);
        this.openDocuments.put(uri, contents.applyTextDocumentChanges(changes));
        return this.didChangeFiles((List<URI>)ImmutableList.of((Object)uri), new ArrayList<URI>());
    }

    public List<IResourceDescription.Delta> didOpen(URI uri, Integer version, String contents, CancelIndicator cancelIndicator) {
        return this.didOpen(uri, version, contents).build(cancelIndicator);
    }

    public XBuildManager.XBuildable didOpen(URI uri, Integer version, String contents) {
        this.openDocuments.put(uri, new Document(version, contents));
        return this.didChangeFiles((List<URI>)ImmutableList.of((Object)uri), new ArrayList<URI>());
    }

    @Deprecated
    public List<IResourceDescription.Delta> didClose(URI uri, CancelIndicator cancelIndicator) {
        return this.didClose(uri).build(cancelIndicator);
    }

    public XBuildManager.XBuildable didClose(URI uri) {
        this.openDocuments.remove(uri);
        if (this.exists(uri)) {
            return this.didChangeFiles((List<URI>)ImmutableList.of((Object)uri), new ArrayList<URI>());
        }
        return this.didChangeFiles(new ArrayList<URI>(), (List<URI>)ImmutableList.of((Object)uri));
    }

    protected boolean exists(URI uri) {
        XtextResourceSet rs;
        XProjectManager projectManager = this.getProjectManager(uri);
        if (projectManager != null && (rs = projectManager.getResourceSet()) != null) {
            return rs.getURIConverter().exists(uri, null);
        }
        return false;
    }

    public <T> T doRead(URI uri, Functions.Function2<? super Document, ? super XtextResource, ? extends T> work) {
        URI resourceURI = uri.trimFragment();
        XProjectManager projectMnr = this.getProjectManager(resourceURI);
        if (projectMnr != null) {
            XtextResource resource = (XtextResource)projectMnr.getResource(resourceURI);
            Document doc = this.getDocument(resource);
            return (T)work.apply((Object)doc, (Object)resource);
        }
        return (T)work.apply(null, null);
    }

    protected Document getDocument(XtextResource resource) {
        Document doc = this.openDocuments.get(resource.getURI());
        if (doc != null) {
            return doc;
        }
        String text = resource.getParseResult().getRootNode().getText();
        return new Document(Integer.valueOf(1), text);
    }

    public boolean isDocumentOpen(URI uri) {
        return this.openDocuments.containsKey(uri);
    }
}

