/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.build;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.ide.xtext.server.build.XBuildContext;
import org.eclipse.n4js.ide.xtext.server.build.XBuildRequest;
import org.eclipse.n4js.ide.xtext.server.build.XIndexState;
import org.eclipse.n4js.ide.xtext.server.build.XIndexer;
import org.eclipse.n4js.ide.xtext.server.build.XSource2GeneratedMapping;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.GeneratorDelegate;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider2;
import org.eclipse.xtext.generator.IFilePostProcessor;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.IShouldGenerate;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.URIBasedFileSystemAccess;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.DisabledClusteringPolicy;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.resource.persistence.IResourceStorageFacade;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class XIncrementalBuilder {
    @Inject
    private Provider<XInternalStatefulIncrementalBuilder> provider;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public XResult build(XBuildRequest request, Functions.Function1<? super URI, ? extends IResourceServiceProvider> languages) {
        return this.build(request, languages, (IResourceClusteringPolicy)new DisabledClusteringPolicy());
    }

    public XResult build(XBuildRequest request, Functions.Function1<? super URI, ? extends IResourceServiceProvider> languages, IResourceClusteringPolicy clusteringPolicy) {
        XtextResourceSet resourceSet = request.getResourceSet();
        XIndexState oldState = new XIndexState(request.getState().getResourceDescriptions().copy(), request.getState().getFileMappings().copy());
        XBuildContext context = new XBuildContext(languages, resourceSet, oldState, clusteringPolicy, request.getCancelIndicator());
        XInternalStatefulIncrementalBuilder builder = (XInternalStatefulIncrementalBuilder)this.provider.get();
        builder.setContext(context);
        builder.setRequest(request);
        try {
            return builder.launch();
        }
        catch (Throwable t) {
            this.operationCanceledManager.propagateIfCancelException(t);
            throw t;
        }
    }

    public static class XInternalStatefulIncrementalBuilder {
        private XBuildContext context;
        private XBuildRequest request;
        @Inject
        private XIndexer indexer;
        @Inject
        private OperationCanceledManager operationCanceledManager;

        protected void unloadResource(URI uri) {
            XtextResourceSet resourceSet = this.request.getResourceSet();
            Resource resource = resourceSet.getResource(uri, false);
            if (resource != null) {
                resourceSet.getResources().remove((Object)resource);
                resource.unload();
            }
        }

        public XResult launch() {
            XSource2GeneratedMapping newSource2GeneratedMapping = this.request.getState().getFileMappings();
            HashSet<URI> unloaded = new HashSet<URI>();
            for (URI deleted : this.request.getDeletedFiles()) {
                if (!unloaded.add(deleted)) continue;
                this.unloadResource(deleted);
            }
            for (URI dirty : this.request.getDirtyFiles()) {
                if (!unloaded.add(dirty)) continue;
                this.unloadResource(dirty);
            }
            for (URI source : this.request.getDeletedFiles()) {
                this.request.getAfterValidate().afterValidate(source, Collections.emptyList());
                for (URI generated : newSource2GeneratedMapping.deleteSource(source)) {
                    IResourceServiceProvider serviceProvider = this.context.getResourceServiceProvider(source);
                    XtextResourceSet resourceSet = this.request.getResourceSet();
                    Set configs = ((IContextualOutputConfigurationProvider2)serviceProvider.get(IContextualOutputConfigurationProvider2.class)).getOutputConfigurations((ResourceSet)resourceSet);
                    String configName = newSource2GeneratedMapping.getOutputConfigName(generated);
                    OutputConfiguration config = (OutputConfiguration)FluentIterable.from((Iterable)configs).firstMatch(it -> it.getName().equals(configName)).orNull();
                    if (config == null || !config.isCleanUpDerivedResources()) continue;
                    try {
                        resourceSet.getURIConverter().delete(generated, CollectionLiterals.emptyMap());
                        this.request.getAfterDeleteFile().apply((Object)generated);
                    }
                    catch (IOException e) {
                        Exceptions.sneakyThrow((Throwable)e);
                    }
                }
            }
            XIndexer.XIndexResult result = this.indexer.computeAndIndexAffected(this.request, this.context);
            this.operationCanceledManager.checkCanceled(this.request.getCancelIndicator());
            ArrayList<IResourceDescription.Delta> resolvedDeltas = new ArrayList<IResourceDescription.Delta>();
            for (IResourceDescription.Delta delta : result.getResourceDeltas()) {
                URI uri = delta.getUri();
                if (delta.getOld() != null && unloaded.add(uri)) {
                    this.unloadResource(uri);
                }
                if (delta.getNew() != null) continue;
                resolvedDeltas.add(delta);
            }
            Iterable deltas = this.context.executeClustered((Iterable<URI>)FluentIterable.from(result.getResourceDeltas()).filter(it -> it.getNew() != null).transform(IResourceDescription.Delta::getUri), resource -> {
                CancelIndicator cancelIndicator = this.request.getCancelIndicator();
                this.operationCanceledManager.checkCanceled(cancelIndicator);
                resource.getContents();
                EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)cancelIndicator);
                this.operationCanceledManager.checkCanceled(cancelIndicator);
                IResourceServiceProvider serviceProvider = this.getResourceServiceProvider((Resource)resource);
                IResourceDescription.Manager manager = serviceProvider.getResourceDescriptionManager();
                IResourceDescription description = manager.getResourceDescription(resource);
                SerializableResourceDescription copiedDescription = SerializableResourceDescription.createCopy((IResourceDescription)description);
                result.getNewIndex().addDescription(resource.getURI(), (IResourceDescription)copiedDescription);
                this.operationCanceledManager.checkCanceled(cancelIndicator);
                if (!this.request.isIndexOnly() && this.validate((Resource)resource) && ((IShouldGenerate)serviceProvider.get(IShouldGenerate.class)).shouldGenerate(resource, cancelIndicator)) {
                    this.operationCanceledManager.checkCanceled(cancelIndicator);
                    this.generate((Resource)resource, this.request, newSource2GeneratedMapping);
                }
                IResourceDescription old = this.context.getOldState().getResourceDescriptions().getResourceDescription(resource.getURI());
                return manager.createDelta(old, (IResourceDescription)copiedDescription);
            });
            Iterables.addAll(resolvedDeltas, deltas);
            return new XResult(this.request.getState(), resolvedDeltas);
        }

        private IResourceServiceProvider getResourceServiceProvider(Resource resource) {
            if (resource instanceof XtextResource) {
                return ((XtextResource)resource).getResourceServiceProvider();
            }
            return this.context.getResourceServiceProvider(resource.getURI());
        }

        protected boolean validate(Resource resource) {
            IResourceValidator resourceValidator = this.getResourceServiceProvider(resource).getResourceValidator();
            if (resourceValidator == null) {
                return true;
            }
            List validationResult = resourceValidator.validate(resource, CheckMode.ALL, this.request.getCancelIndicator());
            return this.request.getAfterValidate().afterValidate(resource.getURI(), validationResult);
        }

        protected void generate(Resource resource, XBuildRequest request, XSource2GeneratedMapping newMappings) {
            IResourceStorageFacade resourceStorageFacade;
            IResourceServiceProvider serviceProvider = this.getResourceServiceProvider(resource);
            GeneratorDelegate generator = (GeneratorDelegate)serviceProvider.get(GeneratorDelegate.class);
            if (generator == null) {
                return;
            }
            Set<URI> previous = newMappings.deleteSource(resource.getURI());
            URIBasedFileSystemAccess fileSystemAccess = this.createFileSystemAccess(serviceProvider, resource);
            fileSystemAccess.setBeforeWrite((uri, outputCfgName, contents) -> {
                newMappings.addSource2Generated(resource.getURI(), uri, outputCfgName);
                previous.remove(uri);
                request.getAfterGenerateFile().apply((Object)resource.getURI(), (Object)uri);
                return contents;
            });
            fileSystemAccess.setBeforeDelete(uri -> {
                newMappings.deleteGenerated(uri);
                request.getAfterDeleteFile().apply((Object)uri);
                return true;
            });
            fileSystemAccess.setContext((Object)resource);
            if (request.isWriteStorageResources() && resource instanceof StorageAwareResource && (resourceStorageFacade = ((StorageAwareResource)resource).getResourceStorageFacade()) != null) {
                resourceStorageFacade.saveResource((StorageAwareResource)resource, (IFileSystemAccessExtension3)fileSystemAccess);
            }
            GeneratorContext generatorContext = new GeneratorContext();
            generatorContext.setCancelIndicator(request.getCancelIndicator());
            generator.generate(resource, (IFileSystemAccess2)fileSystemAccess, (IGeneratorContext)generatorContext);
            XtextResourceSet resourceSet = request.getResourceSet();
            for (URI noLongerCreated : previous) {
                try {
                    resourceSet.getURIConverter().delete(noLongerCreated, CollectionLiterals.emptyMap());
                    request.getAfterDeleteFile().apply((Object)noLongerCreated);
                }
                catch (IOException e) {
                    Exceptions.sneakyThrow((Throwable)e);
                }
            }
        }

        protected URIBasedFileSystemAccess createFileSystemAccess(IResourceServiceProvider serviceProvider, Resource resource) {
            return ((XURIBasedFileSystemAccessFactory)serviceProvider.get(XURIBasedFileSystemAccessFactory.class)).newFileSystemAccess(resource, this.request);
        }

        protected XBuildContext getContext() {
            return this.context;
        }

        protected void setContext(XBuildContext context) {
            this.context = context;
        }

        protected XBuildRequest getRequest() {
            return this.request;
        }

        protected void setRequest(XBuildRequest request) {
            this.request = request;
        }

        @Singleton
        public static class XURIBasedFileSystemAccessFactory {
            @Inject
            private IContextualOutputConfigurationProvider outputConfigurationProvider;
            @Inject
            private IFilePostProcessor postProcessor;
            @Inject(optional=true)
            private IEncodingProvider encodingProvider;
            @Inject
            private TraceFileNameProvider traceFileNameProvider;
            @Inject
            private TraceRegionSerializer traceRegionSerializer;
            @Inject(optional=true)
            private IProjectConfigProvider projectConfigProvider;

            public URIBasedFileSystemAccess newFileSystemAccess(Resource resource, XBuildRequest request) {
                ISourceFolder sourceFolder;
                IProjectConfig projectConfig;
                URIBasedFileSystemAccess uriBasedFileSystemAccess = new URIBasedFileSystemAccess();
                uriBasedFileSystemAccess.setOutputConfigurations(IterableExtensions.toMap((Iterable)this.outputConfigurationProvider.getOutputConfigurations(resource), OutputConfiguration::getName));
                uriBasedFileSystemAccess.setPostProcessor(this.postProcessor);
                if (this.encodingProvider != null) {
                    uriBasedFileSystemAccess.setEncodingProvider(this.encodingProvider);
                }
                uriBasedFileSystemAccess.setTraceFileNameProvider(this.traceFileNameProvider);
                uriBasedFileSystemAccess.setTraceRegionSerializer(this.traceRegionSerializer);
                uriBasedFileSystemAccess.setGenerateTraces(true);
                uriBasedFileSystemAccess.setBaseDir(request.getBaseDir());
                if (this.projectConfigProvider != null && (projectConfig = this.projectConfigProvider.getProjectConfig(resource.getResourceSet())) != null && (sourceFolder = projectConfig.findSourceFolderContaining(resource.getURI())) != null) {
                    uriBasedFileSystemAccess.setCurrentSource(sourceFolder.getName());
                }
                uriBasedFileSystemAccess.setConverter(resource.getResourceSet().getURIConverter());
                return uriBasedFileSystemAccess;
            }
        }
    }

    public static class XResult {
        private final XIndexState indexState;
        private final List<IResourceDescription.Delta> affectedResources;

        public XResult(XIndexState indexState, List<IResourceDescription.Delta> affectedResources) {
            this.indexState = indexState;
            this.affectedResources = affectedResources;
        }

        public XIndexState getIndexState() {
            return this.indexState;
        }

        public List<IResourceDescription.Delta> getAffectedResources() {
            return this.affectedResources;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + (this.indexState == null ? 0 : this.indexState.hashCode());
            return prime * result + (this.affectedResources == null ? 0 : this.affectedResources.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XResult other = (XResult)obj;
            if (this.indexState == null ? other.indexState != null : !this.indexState.equals(other.indexState)) {
                return false;
            }
            return !(this.affectedResources == null ? other.affectedResources != null : !this.affectedResources.equals(other.affectedResources));
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("indexState", (Object)this.indexState);
            b.add("affectedResources", this.affectedResources);
            return b.toString();
        }
    }
}

