/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.nodejs;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.IllegalBinaryStateException;
import org.eclipse.n4js.binaries.nodejs.NodeJsBinary;
import org.eclipse.n4js.runner.IExecutor;
import org.eclipse.n4js.runner.IRunner;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.extension.IRunnerDescriptor;
import org.eclipse.n4js.runner.extension.RunnerDescriptorImpl;
import org.eclipse.n4js.runner.extension.RuntimeEnvironment;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class NodeRunner
implements IRunner {
    private static final String NODE_PATH = "NODE_PATH";
    private static final String NODE_PATH_SEP = File.pathSeparator;
    private static final Splitter OPTIONS_SPLITTER = Splitter.on((CharMatcher)CharMatcher.breakingWhitespace()).omitEmptyStrings().trimResults();
    public static final String ID = "org.eclipse.n4js.runner.nodejs.NODEJS";
    public static final IRunnerDescriptor DESCRIPTOR = new RunnerDescriptorImpl("org.eclipse.n4js.runner.nodejs.NODEJS", "Node.js Runner", RuntimeEnvironment.NODEJS, (IRunner)new NodeRunner());
    @Inject
    private Provider<NodeJsBinary> nodeJsBinaryProvider;

    public RunConfiguration createConfiguration() {
        return new RunConfiguration();
    }

    public void prepareConfiguration(RunConfiguration config) {
    }

    public Process run(RunConfiguration runConfig, IExecutor executor) throws ExecutionException {
        NodeJsBinary nodeJsBinary = (NodeJsBinary)this.nodeJsBinaryProvider.get();
        IStatus status = nodeJsBinary.validate();
        if (!status.isOK()) {
            Exceptions.sneakyThrow((Throwable)new IllegalBinaryStateException((Binary)nodeJsBinary, status));
        }
        String[] cmd = this.createCommand(runConfig);
        Path workingDirectory = runConfig.getWorkingDirectory();
        if (workingDirectory == null) {
            throw new IllegalArgumentException("run configuration does not specify a working directory");
        }
        Map<String, String> env = new LinkedHashMap<String, String>();
        env.putAll(runConfig.getEnvironmentVariables());
        Collection additionalPaths = runConfig.getAdditionalPaths();
        if (additionalPaths != null && !additionalPaths.isEmpty()) {
            env.put(NODE_PATH, Joiner.on((String)NODE_PATH_SEP).join((Iterable)additionalPaths));
        }
        env = nodeJsBinary.updateEnvironment(env);
        return executor.exec(cmd, workingDirectory.toFile(), env);
    }

    private String[] createCommand(RunConfiguration runConfig) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(((NodeJsBinary)this.nodeJsBinaryProvider.get()).getBinaryAbsolutePath());
        cmd.add("-r");
        cmd.add("esm");
        String engineOptions = runConfig.getEngineOptions();
        for (String engineOption : this.splitOptions(engineOptions)) {
            cmd.add(engineOption);
        }
        Path fileToRun = runConfig.getFileToRun();
        if (fileToRun == null) {
            throw new IllegalArgumentException("run configuration does not specify a file to run");
        }
        cmd.add(fileToRun.toString());
        String runOptions = runConfig.getRunOptions();
        for (String runOption : this.splitOptions(runOptions)) {
            cmd.add(runOption);
        }
        return cmd.toArray(new String[0]);
    }

    private Iterable<String> splitOptions(String optionsString) {
        return optionsString != null ? OPTIONS_SPLITTER.split((CharSequence)optionsString.trim()) : Collections.emptyList();
    }

    public static final class NodeRunnerDescriptorProvider
    implements Provider<IRunnerDescriptor> {
        @Inject
        private Provider<NodeRunner> nodeRunnerProvider;

        public IRunnerDescriptor get() {
            return new RunnerDescriptorImpl(NodeRunner.ID, "Node.js Runner", RuntimeEnvironment.NODEJS, (IRunner)this.nodeRunnerProvider.get());
        }
    }
}

