/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner;

import com.google.common.base.Strings;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.runner.extension.RuntimeEnvironment;

public class RunConfiguration {
    public static final String NAME = "NAME";
    public static final String RUNNER_ID = "RUNNER_ID";
    public static final String RUNTIME_ENVIRONMENT = "RUNTIME_ENVIRONMENT";
    public static final String USER_SELECTION = "USER_SELECTION";
    public static final String IMPLEMENTATION_ID = "IMPLEMENTATION_ID";
    public static final String WORKING_DIRECTORY = "WORKING_DIRECTORY";
    public static final String FILE_TO_RUN = "FILE_TO_RUN";
    public static final String ENGINE_OPTIONS = "ENGINE_OPTIONS";
    public static final String RUN_OPTIONS = "RUN_OPTIONS";
    public static final String ENV_VARS = "ENV_VARS";
    public static final String EXEC_DATA_KEY__USER_SELECTION = "userSelection";
    public static final String EXEC_DATA_KEY__PROJECT_NAME_MAPPING = "projectNameMapping";
    private String name;
    private String runnerId;
    private String engineOptions;
    private final Map<String, Object> executionData = new LinkedHashMap<String, Object>();
    private RuntimeEnvironment runtimeEnvironment;
    private N4JSProjectName implementationId;
    private final Map<N4JSProjectName, N4JSProjectName> apiImplProjectMapping = new LinkedHashMap<N4JSProjectName, N4JSProjectName>();
    private URI userSelection;
    private Path workingDirectory;
    private Path fileToRun;
    private String runOptions;
    private final Map<String, String> environmentVariables = new LinkedHashMap<String, String>();
    private final Map<Path, N4JSProjectName> coreProjectPaths = new LinkedHashMap<Path, N4JSProjectName>();
    private final LinkedHashSet<String> additionalPaths = new LinkedHashSet();

    public Collection<String> getAdditionalPaths() {
        return this.additionalPaths;
    }

    public void addAdditionalPath(String file) {
        this.additionalPaths.add(file);
    }

    public void addAdditionalPath(Collection<String> files) {
        this.additionalPaths.addAll(files);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEngineOptions() {
        return Strings.nullToEmpty((String)this.engineOptions);
    }

    public void setEngineOptions(String engineOptions) {
        this.engineOptions = Strings.nullToEmpty((String)engineOptions);
    }

    public Map<String, String> getEnvironmentVariables() {
        return Collections.unmodifiableMap(this.environmentVariables);
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables.clear();
        if (environmentVariables != null) {
            this.environmentVariables.putAll(environmentVariables);
        }
    }

    public String getRunnerId() {
        return this.runnerId;
    }

    public void setRunnerId(String runnerId) {
        this.runnerId = runnerId;
    }

    public RuntimeEnvironment getRuntimeEnvironment() {
        return this.runtimeEnvironment;
    }

    public void setRuntimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
        this.runtimeEnvironment = runtimeEnvironment;
    }

    public URI getUserSelection() {
        return this.userSelection;
    }

    public void setUserSelection(URI userSelection) {
        this.userSelection = userSelection;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(Path workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public Path getFileToRun() {
        return this.fileToRun;
    }

    public void setFileToRun(Path fileToRun) {
        this.fileToRun = fileToRun;
    }

    public String getRunOptions() {
        return Strings.nullToEmpty((String)this.runOptions);
    }

    public void setRunOptions(String runOptions) {
        this.runOptions = Strings.nullToEmpty((String)runOptions);
    }

    public N4JSProjectName getImplementationId() {
        return this.implementationId;
    }

    public void setImplementationId(N4JSProjectName implementationId) {
        this.implementationId = implementationId;
    }

    public Map<N4JSProjectName, N4JSProjectName> getApiImplProjectMapping() {
        return Collections.unmodifiableMap(this.apiImplProjectMapping);
    }

    public void setApiImplProjectMapping(Map<N4JSProjectName, N4JSProjectName> apiImplProjectMapping) {
        this.apiImplProjectMapping.clear();
        this.apiImplProjectMapping.putAll(apiImplProjectMapping);
    }

    public void setApiImplProjectMappingFromProjects(Map<IN4JSProject, IN4JSProject> apiImplProjectMapping) {
        this.apiImplProjectMapping.clear();
        apiImplProjectMapping.entrySet().forEach(e -> {
            N4JSProjectName n4JSProjectName = this.apiImplProjectMapping.put(((IN4JSProject)e.getKey()).getProjectName(), ((IN4JSProject)e.getValue()).getProjectName());
        });
    }

    public Map<String, Object> getExecutionData() {
        return this.executionData;
    }

    public void setExecutionData(Map<String, Object> data) {
        this.executionData.clear();
        this.executionData.putAll(data);
    }

    public String getExecutionDataAsJSON() {
        return JSON.toString(this.executionData);
    }

    public void setExecutionData(String key, Object value) {
        this.executionData.put(key, value);
    }

    public Map<Path, N4JSProjectName> getCoreProjectPaths() {
        return Collections.unmodifiableMap(this.coreProjectPaths);
    }

    public void setCoreProjectPaths(Map<Path, N4JSProjectName> paths) {
        this.coreProjectPaths.clear();
        this.coreProjectPaths.putAll(paths);
    }

    public void addCoreProjectPaths(Map<Path, N4JSProjectName> paths) {
        this.coreProjectPaths.putAll(paths);
    }

    public Map<String, Object> readPersistentValues() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(NAME, this.name);
        result.put(RUNNER_ID, this.runnerId);
        result.put(RUNTIME_ENVIRONMENT, RunConfiguration.toString(this.runtimeEnvironment.getProjectName()));
        result.put(IMPLEMENTATION_ID, RunConfiguration.toString(this.implementationId));
        result.put(USER_SELECTION, this.userSelection.toString());
        result.put(ENGINE_OPTIONS, this.getEngineOptions());
        result.put(RUN_OPTIONS, this.getRunOptions());
        result.put(ENV_VARS, this.getEnvironmentVariables());
        return result;
    }

    private static String toString(N4JSProjectName projectName) {
        if (projectName == null) {
            return null;
        }
        return projectName.getRawName();
    }

    private static N4JSProjectName toName(String projectName) {
        if (projectName == null) {
            return null;
        }
        return new N4JSProjectName(projectName);
    }

    public void writePersistentValues(Map<String, Object> map) {
        this.name = RunConfiguration.getString(map, NAME, false);
        this.runnerId = RunConfiguration.getString(map, RUNNER_ID, false);
        this.runtimeEnvironment = RuntimeEnvironment.fromProjectName(RunConfiguration.toName(RunConfiguration.getString(map, RUNTIME_ENVIRONMENT, false)));
        this.implementationId = RunConfiguration.toName(RunConfiguration.getString(map, IMPLEMENTATION_ID, true));
        this.userSelection = RunConfiguration.getURI(map, USER_SELECTION, false);
        this.engineOptions = Strings.nullToEmpty((String)RunConfiguration.getString(map, ENGINE_OPTIONS, true));
        this.runOptions = Strings.nullToEmpty((String)RunConfiguration.getString(map, RUN_OPTIONS, true));
        this.setEnvironmentVariables(RunConfiguration.getMap(map, ENV_VARS, true));
    }

    public static final boolean getBoolean(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            throw new IllegalArgumentException("no value for key '" + key + "'");
        }
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("value for key '" + key + "' is expected to be of type Boolean but was: " + value.getClass().getName());
        }
        return (Boolean)value;
    }

    public static final String getString(Map<String, Object> map, String key, boolean allowNull) {
        Object value = map.get(key);
        if (value == null && !allowNull) {
            throw new IllegalArgumentException("no value for key '" + key + "'");
        }
        if (value != null && !(value instanceof String)) {
            throw new IllegalArgumentException("value for key '" + key + "' is expected to be of type String but was: " + value.getClass().getName());
        }
        return (String)value;
    }

    public static final Map<String, String> getMap(Map<String, Object> map, String key, boolean allowNull) {
        Object value = map.get(key);
        if (value == null && !allowNull) {
            throw new IllegalArgumentException("no value for key '" + key + "'");
        }
        if (value != null && !(value instanceof Map)) {
            throw new IllegalArgumentException("value for key '" + key + "' is expected to be of type Map but was: " + value.getClass().getName());
        }
        return (Map)value;
    }

    public static final URI getURI(Map<String, Object> map, String key, boolean allowNull) {
        String value = RunConfiguration.getString(map, key, allowNull);
        return value != null ? URI.createURI((String)value) : null;
    }

    public static final List<String> getListOfString(Map<String, Object> map, String key, boolean allowNull) {
        boolean wrongType;
        Object value = map.get(key);
        if (value == null) {
            if (!allowNull) {
                throw new IllegalArgumentException("no value for key '" + key + "'");
            }
            return Collections.emptyList();
        }
        boolean bl = wrongType = !(value instanceof List) || ((List)value).stream().anyMatch(v -> !(v instanceof String));
        if (wrongType) {
            throw new IllegalArgumentException("value for key '" + key + "' is expected to be of type List<String> but was: " + value.getClass().getName());
        }
        List result = (List)value;
        return result;
    }
}

