/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.inject.BindingAnnotation;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.xtext.builder.debug.IBuildLogger;

public class BuilderStateLogger
implements IBuildLogger {
    public void log(Object o) {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        BuilderStateConsole console = (BuilderStateConsole)((Object)FluentIterable.from(Arrays.asList(manager.getConsoles())).filter(BuilderStateConsole.class).first().orNull());
        if (console != null) {
            if (o instanceof Throwable) {
                console.println(Throwables.getStackTraceAsString((Throwable)((Throwable)o)));
            } else {
                console.println(String.valueOf(o));
            }
            manager.showConsoleView((IConsole)console);
        }
    }

    @BindingAnnotation
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface BuilderState {
    }

    private static final class BuilderStateConsole
    extends IOConsole {
        private final PrintStream out = new PrintStream((OutputStream)this.newOutputStream(), true);

        private BuilderStateConsole() {
            super("Builder State", BuilderStateConsole.class.getName(), null, true);
        }

        private void println(String message) {
            this.out.println(message);
        }
    }

    public static class Factory
    implements IConsoleFactory {
        public void openConsole() {
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            manager.addConsoles(new IConsole[]{new BuilderStateConsole()});
        }
    }
}

