/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.n4js.external.ExternalProjectsCollector;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.ui.external.ExternalLibraryBuilder;
import org.eclipse.n4js.ui.external.ExternalProjectProvider;
import org.eclipse.n4js.utils.Cancelable;
import org.eclipse.xtext.builder.impl.BuilderStateDiscarder;
import org.eclipse.xtext.builder.impl.IBuildFlag;

@Singleton
public class ExternalLibrariesReloadHelper {
    private static final Logger LOGGER = Logger.getLogger(ExternalLibrariesReloadHelper.class);
    @Inject
    private LibraryManager libManager;
    @Inject
    private ExternalProjectsCollector collector;
    @Inject
    private ExternalProjectProvider projectProvider;
    @Inject
    private ExternalLibraryBuilder externalBuilder;
    @Inject
    private BuilderStateDiscarder builderStateDiscarder;

    public void reloadLibraries(boolean refreshNpmDefinitions, IProgressMonitor monitor) throws InvocationTargetException {
        ISchedulingRule rule = this.externalBuilder.getRule();
        try {
            try {
                Job.getJobManager().beginRule(rule, monitor);
                this.reloadLibrariesInternal(refreshNpmDefinitions, monitor);
            }
            catch (OperationCanceledException e) {
                LOGGER.info((Object)"User abort.");
                Job.getJobManager().endRule(rule);
            }
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    private void reloadLibrariesInternal(boolean refreshNpmDefinitions, IProgressMonitor monitor) throws InvocationTargetException {
        IStatus refreshStatus;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(refreshNpmDefinitions ? 2 : 1));
        if (monitor instanceof Cancelable) {
            ((Cancelable)monitor).setCancelable(false);
        }
        if (monitor.isCanceled()) {
            return;
        }
        if (refreshNpmDefinitions && !(refreshStatus = this.libManager.registerAllExternalProjects((IProgressMonitor)subMonitor.newChild(1))).isOK()) {
            throw new InvocationTargetException((Throwable)new CoreException(refreshStatus));
        }
        ImmutableSet workspaceProjectNames = FluentIterable.from(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects())).filter(p -> p.isAccessible()).transform(p -> p.getName()).toSet();
        ImmutableList toBuild = FluentIterable.from(this.projectProvider.getProjects()).filter(arg_0 -> ExternalLibrariesReloadHelper.lambda$2((Collection)workspaceProjectNames, arg_0)).toList();
        Collection workspaceProjectsToRebuild = this.collector.getWSProjectsDependendingOn((Iterable)toBuild);
        this.externalBuilder.build((Collection<N4JSExternalProject>)toBuild, (IProgressMonitor)subMonitor.newChild(1));
        HashMap args = new HashMap();
        IBuildFlag.FORGET_BUILD_STATE_ONLY.addToMap(args);
        this.builderStateDiscarder.forgetLastBuildState((Iterable)workspaceProjectsToRebuild, args);
    }

    private static /* synthetic */ boolean lambda$2(Collection collection, N4JSExternalProject p) {
        return !collection.contains(p.getName());
    }
}

