/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.ui.workingsets.IDeferredInitializer;
import org.eclipse.n4js.ui.workingsets.PartListener2Adapter;
import org.eclipse.n4js.ui.workingsets.Resetable;
import org.eclipse.n4js.ui.workingsets.SaveParticipantAdapter;
import org.eclipse.n4js.ui.workingsets.TopLevelElementChangedListener;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerBroker;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerStateChangedListener;
import org.eclipse.n4js.utils.Diff;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

@Singleton
public class WorkingSetManagerBrokerImpl
implements WorkingSetManagerBroker {
    private static final Logger LOGGER = Logger.getLogger(WorkingSetManagerBroker.class);
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String QUALIFIER = WorkingSetManagerBroker.class.getName();
    private static final String ACTIVE_MANAGER_KEY = String.valueOf(QUALIFIER) + ".activeManager";
    private static final String IS_WORKINGSET_TOP_LEVEL_KEY = String.valueOf(QUALIFIER) + ".isWorkingSetTopLevel";
    private final Injector injector;
    private final StatusHelper statusHelper;
    private final AtomicReference<WorkingSetManager> activeWorkingSetManager;
    private final AtomicBoolean workingSetTopLevel;
    private final AtomicBoolean alreadyQueuedNavigatorRefresh;
    private final Supplier<Map<String, WorkingSetManager>> contributions;
    private final Collection<TopLevelElementChangedListener> topLevelElementChangeListeners;
    private final Collection<WorkingSetManagerStateChangedListener> workingSetManagerStateChangeListeners;

    @Inject
    private WorkingSetManagerBrokerImpl(Injector injector, StatusHelper statusHelper) {
        this.injector = injector;
        this.statusHelper = statusHelper;
        this.activeWorkingSetManager = new AtomicReference();
        this.workingSetTopLevel = new AtomicBoolean(false);
        this.alreadyQueuedNavigatorRefresh = new AtomicBoolean(false);
        this.contributions = this.initContributions();
        this.topLevelElementChangeListeners = Sets.newHashSet();
        this.workingSetManagerStateChangeListeners = Sets.newHashSet();
        this.restoreState((IProgressMonitor)new NullProgressMonitor());
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            String pluginId = N4JSActivator.getInstance().getBundle().getSymbolicName();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            try {
                workspace.addSaveParticipant(pluginId, (ISaveParticipant)new SaveParticipantAdapter(){

                    @Override
                    public void saving(ISaveContext context) throws CoreException {
                        WorkingSetManagerBrokerImpl.this.saveState((IProgressMonitor)new NullProgressMonitor());
                    }
                });
            }
            catch (CoreException e) {
                LOGGER.error((Object)"Error occurred while attaching save participant to workspace.", (Throwable)e);
            }
        }
    }

    @Override
    public IStatus saveState(IProgressMonitor monitor) {
        Collection<WorkingSetManager> managers = this.getWorkingSetManagers();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(managers.size() + 1));
        MultiStatus error = this.statusHelper.createMultiError("Error occurred while saving state.");
        for (WorkingSetManager manager : managers) {
            IStatus result = manager.saveState((IProgressMonitor)subMonitor.newChild(1));
            if (result.isOK()) continue;
            error.add(result);
        }
        IStatus result = this.saveState();
        if (!result.isOK()) {
            error.add(result);
        }
        return Arrays2.isEmpty((Object[])error.getChildren()) ? this.statusHelper.OK() : error;
    }

    @Override
    public IStatus restoreState(IProgressMonitor monitor) {
        Collection<WorkingSetManager> managers = this.getWorkingSetManagers();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(managers.size() + 1));
        MultiStatus error = this.statusHelper.createMultiError("Error occurred while restoring state.");
        for (WorkingSetManager manager : managers) {
            IStatus result = manager.restoreState((IProgressMonitor)subMonitor.newChild(1));
            if (result.isOK()) continue;
            error.add(result);
        }
        IStatus result = this.restoreState();
        if (!result.isOK()) {
            error.add(result);
        }
        return Arrays2.isEmpty((Object[])error.getChildren()) ? this.statusHelper.OK() : error;
    }

    @Override
    public Preferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(QUALIFIER);
    }

    @Override
    public Collection<WorkingSetManager> getWorkingSetManagers() {
        return Collections.unmodifiableCollection(((Map)this.contributions.get()).values());
    }

    @Override
    public void setActiveManager(WorkingSetManager workingSetManager) {
        Preconditions.checkNotNull((Object)workingSetManager, (Object)"workingSetManager");
        if (!workingSetManager.equals(this.activeWorkingSetManager.get())) {
            this.activeWorkingSetManager.set(workingSetManager);
            this.saveState();
            this.refreshNavigator();
        }
    }

    @Override
    public boolean isActiveManager(WorkingSetManager workingSetManager) {
        return Objects.equal((Object)workingSetManager, (Object)this.activeWorkingSetManager.get());
    }

    @Override
    public WorkingSetManager getActiveManager() {
        return this.activeWorkingSetManager.get();
    }

    @Override
    public boolean isWorkingSetTopLevel() {
        return this.workingSetTopLevel.get();
    }

    @Override
    public void setWorkingSetTopLevel(boolean b) {
        if (b != this.workingSetTopLevel.get()) {
            this.workingSetTopLevel.set(b);
            this.saveState();
            for (TopLevelElementChangedListener listener : this.topLevelElementChangeListeners) {
                listener.topLevelElementChanged(this.workingSetTopLevel.get());
            }
            this.refreshNavigator();
        }
    }

    @Override
    public void addTopLevelElementChangedListener(TopLevelElementChangedListener listener) {
        this.topLevelElementChangeListeners.add((TopLevelElementChangedListener)Preconditions.checkNotNull((Object)listener, (Object)"listener"));
    }

    @Override
    public void removeTopLevelElementChangedListener(TopLevelElementChangedListener listener) {
        this.topLevelElementChangeListeners.remove(Preconditions.checkNotNull((Object)listener, (Object)"listener"));
    }

    @Override
    public void addWorkingSetManagerStateChangedListener(WorkingSetManagerStateChangedListener listener) {
        this.workingSetManagerStateChangeListeners.add((WorkingSetManagerStateChangedListener)Preconditions.checkNotNull((Object)listener, (Object)"listener"));
    }

    @Override
    public void removeWorkingSetManagerStateChangedListener(WorkingSetManagerStateChangedListener listener) {
        this.workingSetManagerStateChangeListeners.remove(Preconditions.checkNotNull((Object)listener, (Object)"listener"));
    }

    @Override
    public void refreshNavigator() {
        this.refreshNavigator(false);
    }

    @Override
    public void fireWorkingSetManagerUpdated(String id, Diff<WorkingSet> diff) {
        if (!diff.isEmpty() && this.isWorkingSetTopLevel()) {
            final WorkingSetManagerStateChangedListener.WorkingSetManagerChangeEvent event = new WorkingSetManagerStateChangedListener.WorkingSetManagerChangeEvent(id, diff);
            UIUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (WorkingSetManagerStateChangedListener listener : WorkingSetManagerBrokerImpl.this.workingSetManagerStateChangeListeners) {
                        listener.workingSetManagerStateChanged(event);
                    }
                }
            });
        }
    }

    @VisibleForTesting
    public void resetState() {
        for (Resetable resetable : FluentIterable.from(this.getWorkingSetManagers()).filter(Resetable.class)) {
            resetable.reset();
        }
        try {
            this.getPreferences().clear();
            this.getPreferences().flush();
            this.workingSetTopLevel.set(false);
            for (TopLevelElementChangedListener listener : this.topLevelElementChangeListeners) {
                listener.topLevelElementChanged(this.workingSetTopLevel.get());
            }
            Collection<WorkingSetManager> managers = this.getWorkingSetManagers();
            if (!managers.isEmpty()) {
                this.activeWorkingSetManager.set(managers.iterator().next());
            } else {
                this.activeWorkingSetManager.set(null);
            }
            this.refreshNavigator(true);
        }
        catch (BackingStoreException e) {
            LOGGER.error((Object)"Error occurred while reseting persisted the state.", (Throwable)e);
        }
    }

    private void refreshNavigator(final boolean resetInput) {
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page;
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    IViewPart view = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
                    if (view instanceof ProjectExplorer) {
                        WorkingSetManagerBrokerImpl.this.asyncRefreshCommonViewer((ProjectExplorer)view, resetInput);
                    } else if (WorkingSetManagerBrokerImpl.this.alreadyQueuedNavigatorRefresh.compareAndSet(false, true)) {
                        PartListener2Adapter listener = new PartListener2Adapter(){

                            @Override
                            public void partActivated(IWorkbenchPartReference partRef) {
                                IViewPart view = partRef.getPage().findView("org.eclipse.ui.navigator.ProjectExplorer");
                                if (view instanceof ProjectExplorer) {
                                    WorkingSetManagerBrokerImpl.this.asyncRefreshCommonViewer((ProjectExplorer)view, resetInput);
                                    page.removePartListener((IPartListener2)this);
                                    (this).WorkingSetManagerBrokerImpl.this.alreadyQueuedNavigatorRefresh.compareAndSet(true, false);
                                }
                            }
                        };
                        page.addPartListener((IPartListener2)listener);
                    }
                }
            }
        });
    }

    private void asyncRefreshCommonViewer(ProjectExplorer explorer, boolean resetInput) {
        this.getWorkingSetManagers().stream().filter(m -> m instanceof IDeferredInitializer).map(m -> (IDeferredInitializer)((Object)m)).filter(m -> m.isInitializationRequired()).forEach(m -> m.lateInit());
        CommonViewer viewer = explorer.getCommonViewer();
        Display d = UIUtils.getDisplay();
        if (!d.isDisposed()) {
            if (resetInput) {
                d.asyncExec(() -> {
                    WorkingSetManager activeManager = this.getActiveManager();
                    if (activeManager != null) {
                        activeManager.discardWorkingSetCaches();
                    }
                    if (!viewer.getTree().isDisposed()) {
                        viewer.setInput(viewer.getInput());
                    }
                });
            } else {
                d.asyncExec(() -> {
                    WorkingSetManager activeManager = this.getActiveManager();
                    if (activeManager != null) {
                        activeManager.discardWorkingSetCaches();
                    }
                    if (!viewer.getTree().isDisposed()) {
                        viewer.refresh(true);
                    }
                });
            }
        }
    }

    private IStatus saveState() {
        Preferences node = this.getPreferences();
        node.putBoolean(IS_WORKINGSET_TOP_LEVEL_KEY, this.workingSetTopLevel.get());
        WorkingSetManager activeManager = this.getActiveManager();
        String activeId = activeManager == null ? null : activeManager.getId();
        node.put(ACTIVE_MANAGER_KEY, Strings.nullToEmpty((String)activeId));
        try {
            node.flush();
            return Status.OK_STATUS;
        }
        catch (BackingStoreException e) {
            String message = "Unexpected error when trying to persist working set broker state.";
            LOGGER.error((Object)"Unexpected error when trying to persist working set broker state.", (Throwable)e);
            return this.statusHelper.createError("Unexpected error when trying to persist working set broker state.", (Throwable)e);
        }
    }

    private IStatus restoreState() {
        Preferences node = this.getPreferences();
        this.workingSetTopLevel.set(node.getBoolean(IS_WORKINGSET_TOP_LEVEL_KEY, false));
        String value = node.get(ACTIVE_MANAGER_KEY, "");
        WorkingSetManager workingSetManager = (WorkingSetManager)((Map)this.contributions.get()).get(value);
        if (workingSetManager == null && !((Map)this.contributions.get()).isEmpty()) {
            workingSetManager = (WorkingSetManager)((Map)this.contributions.get()).values().iterator().next();
        }
        if (workingSetManager != null) {
            this.setActiveManager(workingSetManager);
        }
        return Status.OK_STATUS;
    }

    private Supplier<Map<String, WorkingSetManager>> initContributions() {
        return Suppliers.memoize(() -> {
            IConfigurationElement[] elements;
            if (!Platform.isRunning()) {
                return Collections.emptyMap();
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(WorkingSetManager.EXTENSION_POINT_ID);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    WorkingSetManager manager = (WorkingSetManager)element.createExecutableExtension(CLASS_ATTRIBUTE);
                    this.injector.injectMembers((Object)manager);
                    builder.put((Object)manager.getId(), (Object)manager);
                }
                catch (CoreException e) {
                    LOGGER.error((Object)"Error while trying to instantiate working set manager.", (Throwable)e);
                }
                ++n2;
            }
            return builder.build();
        });
    }
}

