/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.methods.scoping;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.xpect.methods.scoping.EObjectDescriptionToNameWithPositionMapper;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

class ScopeAwareIterable
implements Iterable<String> {
    private final IScope scope;
    private final URI currentURI;
    public final boolean withLineNumber;

    public ScopeAwareIterable(URI currentURI, boolean withLineNumber, IScope scope) {
        this.currentURI = currentURI;
        this.scope = scope;
        this.withLineNumber = withLineNumber;
    }

    public URI getCurrentURI() {
        return this.currentURI;
    }

    @Override
    public Iterator<String> iterator() {
        Iterator iter1 = this.scope.getAllElements().iterator();
        UnmodifiableIterator iter2 = Iterators.filter(iter1, desc -> !IEObjectDescriptionWithError.isErrorDescription((IEObjectDescription)desc));
        return Iterators.transform((Iterator)iter2, (Function)new EObjectDescriptionToNameWithPositionMapper(this.getCurrentURI(), this.withLineNumber));
    }

    public IScope getScope() {
        return this.scope;
    }
}

