/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.server.HashedFileContent;
import org.eclipse.n4js.ide.server.N4JSWorkspaceManager;
import org.eclipse.n4js.ide.server.ProjectStatePersister;
import org.eclipse.n4js.ide.xtext.server.XProjectManager;
import org.eclipse.n4js.ide.xtext.server.build.XBuildRequest;
import org.eclipse.n4js.ide.xtext.server.build.XIncrementalBuilder;
import org.eclipse.n4js.ide.xtext.server.build.XIndexState;
import org.eclipse.n4js.ide.xtext.server.build.XSource2GeneratedMapping;
import org.eclipse.n4js.projectModel.lsp.ex.IProjectConfigEx;
import org.eclipse.n4js.projectModel.lsp.ex.ISourceFolderEx;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.lib.Procedures;

public class N4JSProjectManager
extends XProjectManager {
    @Inject
    private ProjectStatePersister projectStatePersister;
    @Inject
    private N4JSWorkspaceManager workspaceManager;
    private Map<URI, HashedFileContent> hashFileContents = new HashMap<URI, HashedFileContent>();
    private Map<URI, HashedFileContent> newFileContents = new HashMap<URI, HashedFileContent>();
    private IProjectConfigEx projectConfig;

    @Override
    public void initialize(ProjectDescription description, IProjectConfig pProjectConfig, Procedures.Procedure2<? super URI, ? super Iterable<Issue>> acceptor, IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider, Provider<Map<String, ResourceDescriptionsData>> indexProvider, CancelIndicator cancelIndicator) {
        super.initialize(description, pProjectConfig, acceptor, openedDocumentsContentProvider, indexProvider, cancelIndicator);
        this.projectConfig = (IProjectConfigEx)pProjectConfig;
        this.projectStatePersister.readProjectState((IProjectConfig)this.projectConfig, (indexState, fingerprints) -> {
            this.setIndexState((XIndexState)indexState);
            fingerprints.forEach(fp -> {
                HashedFileContent hashedFileContent = this.hashFileContents.put(fp.getUri(), (HashedFileContent)fp);
            });
        });
        HashSet<URI> newOrChanged = new HashSet<URI>();
        HashSet<URI> allUris = new HashSet<URI>();
        XSource2GeneratedMapping sourceFileMappings = this.getIndexState().getFileMappings();
        for (ISourceFolder srcFolder : this.projectConfig.getSourceFolders()) {
            ISourceFolderEx srcFolderEx = (ISourceFolderEx)srcFolder;
            List allResources = srcFolderEx.getAllResources();
            block1: for (URI sourceURI : allResources) {
                if (".n4js.projectstate".equals(sourceURI.lastSegment()) || !allUris.add(sourceURI)) continue;
                HashedFileContent fingerprint = this.hashFileContents.get(sourceURI);
                if (fingerprint != null) {
                    HashedFileContent newHash = this.doHash(sourceURI);
                    if (newHash == null || fingerprint.getHash() != newHash.getHash()) {
                        newOrChanged.add(sourceURI);
                        continue;
                    }
                    List<URI> prevGenerated = sourceFileMappings.getGenerated(sourceURI);
                    for (URI generated : prevGenerated) {
                        HashedFileContent generatedHash;
                        HashedFileContent genFingerprint = this.hashFileContents.get(generated);
                        if (genFingerprint == null || (generatedHash = this.doHash(generated)) != null && generatedHash.getHash() == genFingerprint.getHash()) continue;
                        newOrChanged.add(sourceURI);
                        continue block1;
                    }
                    continue;
                }
                newOrChanged.add(sourceURI);
            }
        }
        ArrayList<URI> deleted = new ArrayList<URI>();
        for (URI inIndex : this.getIndexState().getResourceDescriptions().getAllURIs()) {
            if (allUris.contains(inIndex)) continue;
            deleted.add(inIndex);
        }
        ArrayList<URI> newOrChangedList = new ArrayList<URI>(newOrChanged);
        this.workspaceManager.getBuildManager().enqueue(description, newOrChangedList, deleted);
        this.doBuild(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), cancelIndicator);
    }

    @Override
    public XIncrementalBuilder.XResult doInitialBuild(CancelIndicator cancelIndicator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XIncrementalBuilder.XResult doBuild(List<URI> dirtyFiles, List<URI> deletedFiles, List<IResourceDescription.Delta> externalDeltas, CancelIndicator cancelIndicator) {
        this.newFileContents = new HashMap<URI, HashedFileContent>(this.hashFileContents);
        this.newFileContents.keySet().removeAll(deletedFiles);
        XIncrementalBuilder.XResult result = super.doBuild(dirtyFiles, deletedFiles, externalDeltas, cancelIndicator);
        if (!cancelIndicator.isCanceled() && !result.getAffectedResources().isEmpty()) {
            dirtyFiles.forEach(this::storeHash);
            this.newFileContents.replaceAll((uri, hash) -> {
                if (hash == null) {
                    hash = this.doHash((URI)uri);
                }
                return hash;
            });
            this.projectStatePersister.writeProjectState((IProjectConfig)this.projectConfig, result.getIndexState(), this.newFileContents.values());
            this.hashFileContents = this.newFileContents;
            this.newFileContents = null;
        }
        return result;
    }

    @Override
    public XBuildRequest newBuildRequest(List<URI> changedFiles, List<URI> deletedFiles, List<IResourceDescription.Delta> externalDeltas, CancelIndicator cancelIndicator) {
        XBuildRequest result = super.newBuildRequest(changedFiles, deletedFiles, externalDeltas, cancelIndicator);
        Procedures.Procedure1<? super URI> afterDeleteFile = result.getAfterDeleteFile();
        Procedures.Procedure2<? super URI, ? super URI> afterGenerateFile = result.getAfterGenerateFile();
        result.setAfterDeleteFile((Procedures.Procedure1<? super URI>)((Procedures.Procedure1)removed -> {
            afterDeleteFile.apply(removed);
            this.newFileContents.remove(removed);
        }));
        result.setAfterGenerateFile((Procedures.Procedure2<? super URI, ? super URI>)((Procedures.Procedure2)(source, target) -> {
            afterGenerateFile.apply(source, target);
            this.scheduleHash((URI)target);
        }));
        if (this.projectConfig.getPath().segmentsList().contains("node_modules")) {
            result.setAfterValidate((uri, issues) -> false);
        }
        return result;
    }

    private void scheduleHash(URI uri) {
        this.newFileContents.put(uri, null);
    }

    private void storeHash(URI uri) {
        HashedFileContent generatedTargetContent = this.doHash(uri);
        if (generatedTargetContent != null) {
            this.newFileContents.put(uri, generatedTargetContent);
        }
    }

    private HashedFileContent doHash(URI uri) {
        try {
            HashedFileContent generatedTargetContent = new HashedFileContent(uri, new File(new java.net.URI(uri.toString())));
            return generatedTargetContent;
        }
        catch (IOException | URISyntaxException e) {
            return null;
        }
    }
}

