/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.n4js.smith.CollectedDataAccess;
import org.eclipse.n4js.smith.DataCollectorCSVExporter;
import org.eclipse.n4js.smith.ui.Activator;
import org.eclipse.n4js.smith.ui.graph.ChartGraphFactory;
import org.eclipse.n4js.smith.ui.graph.StackGraphFactory;
import org.eclipse.n4js.smith.ui.graph.VisualisationCanvas;
import org.eclipse.n4js.smith.ui.graph.VisualisationLabelProvider;
import org.eclipse.n4js.smith.ui.graph.VisualisationSnapshot;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class DashboardComposite
extends Composite {
    private static final float STACK_BASE_WIDTH = 1000.0f;
    private static final float STACK_BASE_HEIGHT = 10.0f;
    private String key = null;
    private final List<VisualisationSnapshot> entries = new ArrayList<VisualisationSnapshot>();
    private ListViewer listViewer;
    private final VisualisationCanvas canvas;
    private final Text text;
    private final DateFormat dateFormat = new SimpleDateFormat("hh:mm:ss.SSS");

    public DashboardComposite(String key, Composite parent, int style) {
        super(parent, style);
        this.key = key;
        this.setLayout((Layout)new FillLayout());
        SashForm sf = new SashForm((Composite)this, 256);
        sf.setLayout((Layout)new FillLayout());
        this.canvas = new VisualisationCanvas((Composite)sf, 0);
        this.text = new Text((Composite)sf, 19202);
        this.text.setText("");
        this.createVisualisationControls((Composite)sf);
        sf.setWeights(new int[]{45, 45, 10});
    }

    private void createVisualisationControls(Composite parent) {
        Composite composite = new Composite(parent, 256);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 1, true, true));
        ToolBar bar = new ToolBar(composite, 256);
        bar.setLayoutData((Object)new GridData(4, 1, true, false));
        this.createToolbarActions(bar);
        this.listViewer = new ListViewer(composite, 514);
        this.listViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new VisualisationLabelProvider());
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DashboardComposite.this.onSelectionChanged(event);
            }
        });
        this.listViewer.getList().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u007f') {
                    DashboardComposite.this.removeSelectedGraphs(false);
                }
            }
        });
    }

    private void createToolbarActions(ToolBar bar) {
        this.createAction(bar, 8, "Snapshot", "Take a data snapshot.", Activator.getInstance().ICON_SNAPSHOT, this::takeSnapshot);
        this.createAction(bar, 8, "Snapshot and Save", "Take a data snapshot and save it as CSV file.", Activator.getInstance().ICON_SNAPSHOT_SAVE, this::takeSnapshotAndSave);
        this.createAction(bar, 8, "Delete", "Delete selected snapshots from history.", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"), this::deleteCurrentSelection);
    }

    private void createAction(ToolBar bar, int style, String label, String tooltip, ImageDescriptor image, final Runnable action) {
        ToolItem item = new ToolItem(bar, style);
        item.setImage(image.createImage());
        item.setText(label);
        item.setToolTipText(tooltip);
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void deleteCurrentSelection() {
        this.removeSelectedGraphs(false);
    }

    public void removeSelectedGraphs(boolean removeAllIfNothingSelected) {
        ISelection sel = this.listViewer.getSelection();
        if (!sel.isEmpty()) {
            this.removeEntries(((IStructuredSelection)sel).toList());
        } else if (removeAllIfNothingSelected) {
            this.removeEntries(new ArrayList<VisualisationSnapshot>(this.entries));
        }
    }

    public void removeAllGraphs() {
        this.removeEntries(this.entries);
        this.clearRenderedData();
    }

    private void clearRenderedData() {
        this.canvas.clear();
        this.text.setText("");
    }

    private void onSelectionChanged(SelectionChangedEvent event) {
        VisualisationSnapshot selEntry = this.getSingleSelectedEntry();
        if (selEntry != null) {
            this.canvas.setGraph(selEntry.graph);
            this.text.setText(selEntry.text);
        } else {
            this.clearRenderedData();
        }
    }

    private void removeEntries(Collection<?> entries) {
        if (this.entries.removeAll(entries)) {
            this.refreshList();
            if (entries.stream().anyMatch(e -> e instanceof VisualisationSnapshot && ((VisualisationSnapshot)e).graph == this.canvas.getGraph())) {
                this.clearRenderedData();
            }
        }
    }

    protected VisualisationSnapshot getSingleSelectedEntry() {
        Object obj;
        IStructuredSelection sel = (IStructuredSelection)this.listViewer.getSelection();
        Object object = obj = sel.size() == 1 ? sel.getFirstElement() : null;
        if (obj instanceof VisualisationSnapshot) {
            return (VisualisationSnapshot)obj;
        }
        return null;
    }

    private void takeSnapshotAndSave() {
        if (this.saveCSVFileOfSnapshot()) {
            this.takeSnapshot();
        }
    }

    private boolean saveCSVFileOfSnapshot() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setFilterNames(new String[]{"CSV (comma-separated value) files (*.csv)"});
        fileDialog.setFilterExtensions(new String[]{"*.csv"});
        fileDialog.setFileName(String.valueOf(this.getTimeStamp()) + ".csv");
        String filePath = fileDialog.open();
        if (filePath == null) {
            return false;
        }
        File outputFile = new File(filePath);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileWriter writer = new FileWriter(outputFile);){
                String csvData = DataCollectorCSVExporter.toCSV((String)this.key);
                writer.write(csvData);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Failed to save CSV file", (String)("Could not save CSV file at specified location " + filePath), (IStatus)new Status(4, "org.eclipse.n4js.smith.ui", "Failed to save CSV file with performance data.", (Throwable)e));
            return false;
        }
        return true;
    }

    private void takeSnapshot() {
        this.showGraph("");
    }

    public void showGraph(final String label) {
        if (this.isDisposed()) {
            return;
        }
        final String prefix = String.valueOf(this.getTimeStamp()) + ": ";
        if (Display.getCurrent() != null) {
            this.addGraph(String.valueOf(prefix) + label, true);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DashboardComposite.this.addGraph(String.valueOf(prefix) + label, true);
                }
            });
        }
    }

    public void addGraph(String label, boolean select) {
        if (CollectedDataAccess.hasNestedData((String)this.key)) {
            this.addEntry(StackGraphFactory.buildGraph(this.key, 10.0f, 1000.0f, label), select);
        } else {
            Rectangle clientArea = this.canvas.getClientArea();
            int chartHeight = clientArea.height;
            int chartWidth = clientArea.width;
            this.addEntry(ChartGraphFactory.buildGraph(this.key, chartHeight, chartWidth, label), select);
        }
        this.layout();
    }

    private void addEntry(VisualisationSnapshot entry, boolean select) {
        if (!this.entries.contains(entry)) {
            this.entries.add(entry);
            this.refreshList();
            if (select) {
                this.listViewer.setSelection((ISelection)new StructuredSelection((Object)entry));
                this.listViewer.reveal((Object)entry);
            }
        }
    }

    private void refreshList() {
        this.listViewer.setInput((Object)this.entries.toArray());
        this.listViewer.refresh();
    }

    public boolean setFocus() {
        return this.listViewer.getList().setFocus();
    }

    private String getTimeStamp() {
        return this.dateFormat.format(new Date());
    }
}

