/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.ts.scoping.builtin.N4Scheme;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.containers.FlatResourceSetBasedAllContainersState;
import org.eclipse.xtext.resource.containers.IAllContainersState;
import org.eclipse.xtext.resource.containers.ResourceSetBasedAllContainersStateProvider;

public class N4JSTestsAllContainerState
extends FlatResourceSetBasedAllContainersState {
    private static final String N4SCHEME_HANDLE = "n4scheme";
    private static final String TEST_HANDLE = "test";

    public N4JSTestsAllContainerState(ResourceSet set) {
        super(set);
    }

    public boolean isEmpty(String handle) {
        return !handle.equals(TEST_HANDLE) && !handle.equals(N4SCHEME_HANDLE);
    }

    public List<String> getVisibleContainerHandles(String handle) {
        if (handle.equals(TEST_HANDLE) || handle.equals(N4SCHEME_HANDLE)) {
            return Collections.singletonList(handle);
        }
        return Collections.emptyList();
    }

    public Collection<URI> getContainedURIs(String containerHandle) {
        if (containerHandle.equals(TEST_HANDLE)) {
            Collection allResourceURIs = super.getContainedURIs(FlatResourceSetBasedAllContainersState.getHandle());
            return allResourceURIs.parallelStream().filter(uri -> !N4Scheme.isN4Scheme((URI)uri)).collect(Collectors.toList());
        }
        if (containerHandle.equals(N4SCHEME_HANDLE)) {
            Collection allResourceURIs = super.getContainedURIs(FlatResourceSetBasedAllContainersState.getHandle());
            return allResourceURIs.parallelStream().filter(uri -> N4Scheme.isN4Scheme((URI)uri)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String getContainerHandle(URI uri) {
        if (N4Scheme.isN4Scheme((URI)uri)) {
            return N4SCHEME_HANDLE;
        }
        return TEST_HANDLE;
    }

    public static class Provider
    extends ResourceSetBasedAllContainersStateProvider {
        public IAllContainersState get(IResourceDescriptions context) {
            return new N4JSTestsAllContainerState(this.getResourceSet(context));
        }
    }
}

