/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.projectModel;

import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.tests.projectModel.AbstractProjectModelTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractN4JSCoreTest<Loc extends SafeURI<Loc>>
extends AbstractProjectModelTest<Loc> {
    protected abstract IN4JSCore getN4JSCore();

    @Test
    public void testCreateProjectAndCheckExists_01() {
        IN4JSProject project = this.getN4JSCore().create(this.myProjectURI.appendPath("../doesNotExist").toURI());
        Assert.assertNotNull((Object)project);
        Assert.assertFalse((boolean)project.exists());
    }

    @Test
    public void testCreateProjectAndCheckExists_02() {
        IN4JSProject project = this.getN4JSCore().create(this.myProjectURI.toURI());
        Assert.assertNotNull((Object)project);
        Assert.assertTrue((boolean)project.exists());
    }

    @Test
    public void testCreateYieldsDifferentInstances() {
        IN4JSProject first = this.getN4JSCore().create(this.myProjectURI.toURI());
        IN4JSProject second = this.getN4JSCore().create(this.myProjectURI.toURI());
        Assert.assertNotSame((Object)first, (Object)second);
    }

    @Test
    public void testCreateYieldsEqualsInstances_01() {
        IN4JSProject first = this.getN4JSCore().create(this.myProjectURI.toURI());
        IN4JSProject second = this.getN4JSCore().create(this.myProjectURI.toURI());
        Assert.assertEquals((Object)first, (Object)second);
    }

    @Test
    public void testCreateYieldsEqualsInstances_02() {
        URI doesNotExist = this.myProjectURI.appendPath("../doesNotExist").toURI();
        IN4JSProject first = this.getN4JSCore().create(doesNotExist);
        IN4JSProject second = this.getN4JSCore().create(doesNotExist);
        Assert.assertEquals((Object)first, (Object)second);
    }

    @Test
    public void testProjectId_01() {
        IN4JSProject project = this.getN4JSCore().create(this.myProjectURI.appendPath("../doesNotExist").toURI());
        Assert.assertNotNull((Object)project);
        Assert.assertEquals((Object)"doesNotExist", (Object)project.getProjectName().getRawName());
    }

    @Test
    public void testProjectId_02() {
        IN4JSProject project = this.getN4JSCore().create(this.myProjectURI.toURI());
        Assert.assertNotNull((Object)project);
        Assert.assertEquals((Object)this.myProjectName, (Object)project.getProjectName());
    }

    @Test
    public void testFindProject_01() {
        IN4JSProject project = (IN4JSProject)this.getN4JSCore().findProject(this.myProjectURI.toURI()).get();
        Assert.assertNotNull((Object)project);
        Assert.assertEquals((Object)this.myProjectName, (Object)project.getProjectName());
    }
}

