/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.ts.utils.LambdaUtils;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class N4JSLambdaValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    ContainerTypesHelper containerTypesHelper;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkTopLevelLambda(ArrowFunction arrowFun) {
        if (LambdaUtils.isTopLevelLambda((FunctionExpression)arrowFun)) {
            this.rejectUsagesOfThisInTopLevelLambda(arrowFun);
        }
    }

    private void rejectUsagesOfThisInTopLevelLambda(ArrowFunction topLevelLambda) {
        assert (LambdaUtils.isLambda((EObject)topLevelLambda));
        Iterator thisUsages = LambdaUtils.thisLiterals((Block)topLevelLambda.getBody());
        while (thisUsages.hasNext()) {
            EObject thisUsage = (EObject)thisUsages.next();
            String message = IssueCodes.getMessageForKEY_THIS_REJECTED_IN_TOP_LEVEL_LAMBDA();
            this.addIssue(message, thisUsage, "KEY_THIS_REJECTED_IN_TOP_LEVEL_LAMBDA");
        }
    }
}

