/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.codegen;

import java.util.List;
import java.util.Objects;
import org.eclipse.n4js.tests.codegen.Fragment;
import org.eclipse.n4js.tests.codegen.Member;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public abstract class Classifier<T extends Classifier<T>>
extends Fragment<T> {
    private Visibility visibility = Visibility.PRIVATE;
    private String name;
    private List<Member<?>> members;

    protected Classifier(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public String getName() {
        return this.name;
    }

    public T makeProjectVisible() {
        return this.setVisibility(Visibility.PROJECT);
    }

    public T makePublicInternal() {
        return this.setVisibility(Visibility.PUBLIC_INTERNAL);
    }

    public T makePublic() {
        return this.setVisibility(Visibility.PUBLIC);
    }

    public T setVisibility(Visibility visibility) {
        this.visibility = visibility;
        return (T)this;
    }

    public T addMember(Member<?> member) {
        if (this.members == null) {
            this.members = CollectionLiterals.newLinkedList();
        }
        this.members.add(Objects.requireNonNull(member));
        return (T)this;
    }

    @Override
    public CharSequence generate() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateVisibility = this.generateVisibility();
        _builder.append((Object)_generateVisibility);
        String _generateAbstract = this.generateAbstract();
        _builder.append(_generateAbstract);
        CharSequence _generateType = this.generateType();
        _builder.append((Object)_generateType);
        _builder.append(this.name);
        CharSequence _generateTypeRelations = this.generateTypeRelations();
        _builder.append((Object)_generateTypeRelations);
        _builder.append(" ");
        boolean _hasMembers = this.hasMembers();
        boolean bl = _not = !_hasMembers;
        if (_not) {
            _builder.append("{}");
        } else {
            _builder.append("{");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _generateMembers = this.generateMembers();
            _builder.append((Object)_generateMembers, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateVisibility() {
        StringConcatenation _builder = new StringConcatenation();
        String _generate = VisibilityExtensions.generate(this.visibility);
        _builder.append(_generate);
        _builder.append(" ");
        return _builder;
    }

    protected CharSequence generateMembers() {
        StringConcatenation _builder = new StringConcatenation();
        for (Member<?> m : this.members) {
            CharSequence _generate = m.generate();
            _builder.append((Object)_generate);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected abstract CharSequence generateType();

    protected abstract CharSequence generateTypeRelations();

    private boolean hasMembers() {
        return this.members != null && !this.members.isEmpty();
    }

    public String toString() {
        return this.generate().toString();
    }

    public static enum Visibility {
        PRIVATE,
        PROJECT,
        PUBLIC_INTERNAL,
        PUBLIC;

    }

    public static class VisibilityExtensions {
        public static String makeName(Visibility visibility, String classifierName) {
            String _nameExtension = VisibilityExtensions.getNameExtension(visibility);
            return String.valueOf(classifierName) + _nameExtension;
        }

        public static String getNameExtension(Visibility visibility) {
            String _switchResult = null;
            if (visibility != null) {
                switch (visibility) {
                    case PRIVATE: {
                        _switchResult = "_private";
                        break;
                    }
                    case PROJECT: {
                        _switchResult = "_project";
                        break;
                    }
                    case PUBLIC_INTERNAL: {
                        _switchResult = "_public_internal";
                        break;
                    }
                    case PUBLIC: {
                        _switchResult = "_public";
                        break;
                    }
                }
            }
            return _switchResult;
        }

        public static String generate(Visibility visibility) {
            String _switchResult = null;
            if (visibility != null) {
                switch (visibility) {
                    case PRIVATE: {
                        _switchResult = "/* private */";
                        break;
                    }
                    case PROJECT: {
                        _switchResult = "export project";
                        break;
                    }
                    case PUBLIC_INTERNAL: {
                        _switchResult = "export @Internal public";
                        break;
                    }
                    case PUBLIC: {
                        _switchResult = "export public";
                        break;
                    }
                }
            }
            return _switchResult;
        }
    }
}

