/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.issues;

import java.util.Objects;
import java.util.function.Function;
import org.eclipse.n4js.tests.issues.IssuePropertyMatcherBase;
import org.eclipse.xtext.validation.Issue;

public class StringPropertyMatcher
extends IssuePropertyMatcherBase {
    private final Mode mode;
    private final boolean ignoreCase;
    private final String expectedPattern;
    private final Function<Issue, String> getActualValue;

    protected StringPropertyMatcher(String propertyName, Mode mode, Boolean ignoreCase, String expectedPattern, Function<Issue, String> getActualValue) {
        super(propertyName);
        this.mode = mode;
        this.ignoreCase = Objects.requireNonNull(ignoreCase);
        this.expectedPattern = this.safeGetValue(expectedPattern);
        this.getActualValue = Objects.requireNonNull(getActualValue);
    }

    @Override
    public boolean matches(Issue issue) {
        String actualValue = this.safeGetValue(this.getActualValue.apply(issue));
        switch (this.mode) {
            case StartsWith: {
                return actualValue.startsWith(this.expectedPattern);
            }
            case EndsWith: {
                return actualValue.endsWith(this.expectedPattern);
            }
            case Equals: {
                return actualValue.equals(this.expectedPattern);
            }
        }
        throw new IllegalStateException("Unknown string property matching mode: " + (Object)((Object)this.mode));
    }

    private String safeGetValue(String value) {
        if (value == null) {
            return null;
        }
        return this.ignoreCase ? value.toLowerCase() : value;
    }

    @Override
    protected String explainMismatch(Issue issue) {
        String actualValue = this.safeGetValue(this.getActualValue.apply(issue));
        switch (this.mode) {
            case StartsWith: {
                return "'" + this.expectedPattern + "' is not a prefix of value '" + actualValue + "'";
            }
            case EndsWith: {
                return "'" + this.expectedPattern + "' is not a suffix of value '" + actualValue + "'";
            }
            case Equals: {
                return "Value '" + actualValue + "' is not equal to expected value'" + this.expectedPattern + "'";
            }
        }
        throw new IllegalStateException("Unknown string property matching mode: " + (Object)((Object)this.mode));
    }

    @Override
    public String getDescription() {
        switch (this.mode) {
            case StartsWith: {
                return "'" + this.expectedPattern + "' is a prefix of property '" + this.getPropertyName() + "'";
            }
            case EndsWith: {
                return "'" + this.expectedPattern + "' is a suffix of property '" + this.getPropertyName() + "'";
            }
            case Equals: {
                return "Property '" + this.getPropertyName() + "' is equal to expected value'" + this.expectedPattern + "'";
            }
        }
        throw new IllegalStateException("Unknown string property matching mode: " + (Object)((Object)this.mode));
    }

    public static enum Mode {
        StartsWith,
        EndsWith,
        Equals;

    }
}

