/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.projectModel;

import com.google.common.collect.ImmutableList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.tests.projectModel.AbstractProjectModelTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractN4JSProjectTest<Loc extends SafeURI<Loc>>
extends AbstractProjectModelTest<Loc> {
    protected abstract IN4JSCore getN4JSCore();

    @Test
    public void testGetLocation_01() {
        IN4JSProject project = this.getN4JSCore().create(this.myProjectURI.toURI());
        Assert.assertEquals((Object)this.myProjectURI, (Object)project.getLocation());
    }

    @Test
    public void testGetLocation_02() {
        URI doesNotExist = this.myProjectURI.appendPath("../doesNotExist").toURI();
        IN4JSProject project = this.getN4JSCore().create(doesNotExist);
        Assert.assertEquals((Object)doesNotExist, (Object)project.getLocation().toURI());
    }

    @Test
    public void testGetSourceContainers_01() {
        IN4JSProject project = this.getN4JSCore().create(this.myProjectURI.toURI());
        ImmutableList sourceContainers = project.getSourceContainers();
        Assert.assertEquals((long)1L, (long)sourceContainers.size());
        Assert.assertEquals((Object)"src", (Object)((IN4JSSourceContainer)sourceContainers.get(0)).getRelativeLocation());
    }

    @Test
    public void testGetSourceContainers_02() {
        URI doesNotExist = this.myProjectURI.appendPath("../doesNotExist").toURI();
        IN4JSProject project = this.getN4JSCore().create(doesNotExist);
        ImmutableList sourceContainers = project.getSourceContainers();
        Assert.assertEquals((long)0L, (long)sourceContainers.size());
    }

    @Test
    public void testGetSourceContainers_03() {
        IN4JSProject project = this.getN4JSCore().create(this.myProjectURI.toURI());
        ImmutableList first = project.getSourceContainers();
        ImmutableList second = project.getSourceContainers();
        Assert.assertEquals((Object)first, (Object)second);
    }

    @Test
    public void testGetDependencies_01() {
        IN4JSProject project = this.getN4JSCore().create(this.myProjectURI.toURI());
        ImmutableList dependencies = project.getDependencies();
        Assert.assertEquals((long)2L, (long)dependencies.size());
        Assert.assertEquals((Object)this.libProjectURI.getName(), (Object)((IN4JSProject)dependencies.get(1)).getLocation().getName());
    }

    @Test
    public void testGetDependencies_02() {
        URI doesNotExist = this.myProjectURI.appendPath("../doesNotExist").toURI();
        IN4JSProject project = this.getN4JSCore().create(doesNotExist);
        ImmutableList dependencies = project.getDependencies();
        Assert.assertEquals((long)0L, (long)dependencies.size());
    }

    @Test
    public void testGetDependencies_03() {
        IN4JSProject project = this.getN4JSCore().create(this.myProjectURI.toURI());
        ImmutableList first = project.getDependencies();
        ImmutableList second = project.getDependencies();
        Assert.assertEquals((Object)first, (Object)second);
    }
}

