/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.outline;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.FieldAccessor;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ScriptElement;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.util.MemberList;
import org.eclipse.n4js.ui.labeling.EObjectWithContext;
import org.eclipse.n4js.ui.labeling.N4JSLabelProvider;
import org.eclipse.n4js.ui.outline.N4JSEObjectNode;
import org.eclipse.n4js.ui.outline.N4JSOutlineModes;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.IOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.BackgroundOutlineTreeProvider;
import org.eclipse.xtext.ui.editor.outline.impl.DocumentRootNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineMode;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class N4JSOutlineTreeProvider
extends BackgroundOutlineTreeProvider
implements IOutlineTreeProvider.ModeAware {
    private static final Logger logger = Logger.getLogger(N4JSOutlineTreeProvider.class);
    @Inject
    private ContainerTypesHelper containerTypesHelper;
    private IOutlineTreeProvider.ModeAware modeAware = null;

    private N4JSLabelProvider getN4JSLabelProvider() {
        ILabelProvider _labelProvider = this.getLabelProvider();
        return (N4JSLabelProvider)_labelProvider;
    }

    public IOutlineNode createRoot(IXtextDocument document, CancelIndicator cancelIndicator) {
        try {
            this.getN4JSLabelProvider().establishCancelIndicator(cancelIndicator);
            IOutlineNode iOutlineNode = super.createRoot(document, cancelIndicator);
            return iOutlineNode;
        }
        finally {
            this.getN4JSLabelProvider().removeCancelIndicator();
        }
    }

    public void createChildren(IOutlineNode parentNode, EObject modelElement) {
        this.checkCanceled();
        if (modelElement != null && parentNode.hasChildren()) {
            try {
                this.createChildren_(parentNode, modelElement);
            }
            catch (Throwable _t) {
                if (_t instanceof Exception) {
                    Exception ex = (Exception)_t;
                    logger.error((Object)"Error creating nodes for children", (Throwable)ex);
                    throw new OperationCanceledException("Canceled due to internal error: " + ex);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    protected void _createChildren_(DocumentRootNode parentNode, EObject modelElement) {
        super.createChildren((IOutlineNode)parentNode, modelElement);
    }

    protected void _createChildren_(IOutlineNode parentNode, EObject modelElement) {
        super.createChildren(parentNode, modelElement);
    }

    protected void _createChildren_(IOutlineNode parentNode, Script script) {
        EObjectNode node = null;
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)script.getScriptElements());
        for (ScriptElement child : _filterNull) {
            node = null;
            if (child instanceof ExportDeclaration) {
                ExportableElement exportedElement = ((ExportDeclaration)child).getExportedElement();
                if (exportedElement instanceof ExportedVariableStatement) {
                    boolean _equals;
                    int _size = ((ExportedVariableStatement)exportedElement).getVarDecl().size();
                    boolean bl = _equals = _size == 1;
                    if (_equals) {
                        node = this.createNode(parentNode, (EObject)IterableExtensions.head((Iterable)((ExportedVariableStatement)exportedElement).getVarDecl()));
                        continue;
                    }
                    node = this.createNode(parentNode, (EObject)exportedElement);
                    continue;
                }
                if (exportedElement == null) continue;
                node = this.createNode(parentNode, (EObject)exportedElement);
                continue;
            }
            if (!this.isInstanceOfExpectedScriptChildren((EObject)child) || !this.canCreateChildNode(child) || !((node = this.createNode(parentNode, (EObject)child)) instanceof N4JSEObjectNode)) continue;
            ((N4JSEObjectNode)node).isLocal = true;
        }
    }

    protected void _createChildren_(IOutlineNode parentNode, N4ClassifierDefinition classifierDefinition) {
        Type _definedType = classifierDefinition.getDefinedType();
        TClassifier tclassifier = (TClassifier)_definedType;
        if (tclassifier != null && this.showInherited()) {
            MemberList members = this.containerTypesHelper.fromContext((EObject)tclassifier).members((ContainerType)tclassifier, false, true);
            Iterable _filterNull = IterableExtensions.filterNull((Iterable)members);
            for (TMember tchild : _filterNull) {
                ICompositeNode nodeModel;
                Resource _eResource_1;
                EObjectWithContext _eObjectWithContext = new EObjectWithContext((EObject)tchild, (EObject)tclassifier);
                EObjectNode node = this.createNodeForObjectWithContext(parentNode, _eObjectWithContext);
                if (!(node instanceof N4JSEObjectNode)) continue;
                if (tchild.getContainingType() != null && !Objects.equal((Object)tchild.getContainingType(), (Object)tclassifier)) {
                    ((N4JSEObjectNode)node).isInherited = true;
                }
                ((N4JSEObjectNode)node).isMember = true;
                ((N4JSEObjectNode)node).isStatic = tchild.isStatic();
                ((N4JSEObjectNode)node).isPublic = Objects.equal((Object)tchild.getMemberAccessModifier(), (Object)MemberAccessModifier.PUBLIC) || Objects.equal((Object)tchild.getMemberAccessModifier(), (Object)MemberAccessModifier.PUBLIC_INTERNAL);
                ((N4JSEObjectNode)node).isConstructor = tchild.isConstructor();
                Resource _eResource = tchild.eResource();
                boolean _equals = Objects.equal((Object)_eResource, (Object)(_eResource_1 = tclassifier.eResource()));
                if (!_equals || (nodeModel = NodeModelUtils.getNode((EObject)tchild.getAstElement())) == null) continue;
                int _offset = nodeModel.getOffset();
                int _length = nodeModel.getLength();
                TextRegion _textRegion = new TextRegion(_offset, _length);
                ((N4JSEObjectNode)node).setTextRegion((ITextRegion)_textRegion);
            }
        } else {
            Iterable _filterNull_1 = IterableExtensions.filterNull((Iterable)classifierDefinition.eContents());
            for (EObject child : _filterNull_1) {
                boolean _isInstanceOfExpectedClassifierChildren = this.isInstanceOfExpectedClassifierChildren(child);
                if (!_isInstanceOfExpectedClassifierChildren) continue;
                this.createNode(parentNode, child);
            }
        }
    }

    public EObjectNode createNodeForObjectWithContext(IOutlineNode parentNode, EObjectWithContext objectWithContext) {
        this.checkCanceled();
        Object text = this.getText(objectWithContext);
        boolean isLeaf = this.isLeaf(objectWithContext.obj);
        if (text == null && isLeaf) {
            return null;
        }
        ImageDescriptor image = this.getImageDescriptor(objectWithContext);
        return this.getOutlineNodeFactory().createEObjectNode(parentNode, objectWithContext.obj, image, text, isLeaf);
    }

    protected void _createChildren_(IOutlineNode parentNode, N4EnumDeclaration ed) {
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)ed.getLiterals());
        for (N4EnumLiteral literal : _filterNull) {
            this.createNode(parentNode, (EObject)literal);
        }
    }

    protected boolean _canCreateChildNode(Object element) {
        return true;
    }

    protected boolean _canCreateChildNode(N4ClassifierDefinition it) {
        Type _definedType = it.getDefinedType();
        return _definedType != null;
    }

    private boolean isInstanceOfExpectedScriptChildren(EObject child) {
        return this.isInstanceOfOneOfTheTypes(child, ExportDeclaration.class, N4ClassifierDeclaration.class, N4EnumDeclaration.class, FunctionDeclaration.class);
    }

    private boolean isInstanceOfExpectedClassifierChildren(EObject child) {
        return this.isInstanceOfOneOfTheTypes(child, N4MemberDeclaration.class, FieldAccessor.class);
    }

    private boolean isInstanceOfOneOfTheTypes(EObject eObject, Class<?> ... classes) {
        Functions.Function1 _function = it -> it.isAssignableFrom(eObject.getClass());
        return IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray(classes)), (Functions.Function1)_function);
    }

    protected boolean _isLeaf(EObject modelElement) {
        return super.isLeaf(modelElement);
    }

    protected boolean _isLeaf(Void _null) {
        return true;
    }

    protected boolean _isLeaf(Script script) {
        Functions.Function1 _function = it -> this.isInstanceOfExpectedScriptChildren((EObject)it);
        boolean _exists = IterableExtensions.exists((Iterable)script.eContents(), (Functions.Function1)_function);
        return !_exists;
    }

    protected boolean _isLeaf(N4ClassifierDefinition classifierDefinition) {
        Type _definedType = classifierDefinition.getDefinedType();
        TClassifier tclassifier = (TClassifier)_definedType;
        if (tclassifier == null) {
            return true;
        }
        boolean _showInherited = this.showInherited();
        if (_showInherited) {
            MemberList members = this.containerTypesHelper.fromContext((EObject)tclassifier).members((ContainerType)tclassifier, false, true);
            return IterableExtensions.isNullOrEmpty((Iterable)members);
        }
        Functions.Function1 _function = it -> this.isInstanceOfExpectedClassifierChildren((EObject)it);
        boolean _exists = IterableExtensions.exists((Iterable)classifierDefinition.eContents(), (Functions.Function1)_function);
        return !_exists;
    }

    protected boolean _isLeaf(TMember member) {
        return true;
    }

    protected boolean _isLeaf(N4FieldDeclaration md) {
        return true;
    }

    protected boolean _isLeaf(FunctionOrFieldAccessor fa) {
        return true;
    }

    protected boolean _isLeaf(ExportedVariableDeclaration vd) {
        return true;
    }

    protected boolean _isLeaf(ImportDeclaration id) {
        int _size = id.getImportSpecifiers().size();
        return _size == 1;
    }

    protected boolean showInherited() {
        if (this.modeAware != null) {
            OutlineMode _currentMode = this.modeAware.getCurrentMode();
            return Objects.equal((Object)_currentMode, (Object)N4JSOutlineModes.SHOW_INHERITED_MODE);
        }
        return true;
    }

    public List<OutlineMode> getOutlineModes() {
        return this.getOrCreateModeAware().getOutlineModes();
    }

    public OutlineMode getCurrentMode() {
        return this.getOrCreateModeAware().getCurrentMode();
    }

    public OutlineMode getNextMode() {
        return this.getOrCreateModeAware().getNextMode();
    }

    public void setCurrentMode(OutlineMode outlineMode) {
        this.getOrCreateModeAware().setCurrentMode(outlineMode);
    }

    private IOutlineTreeProvider.ModeAware getOrCreateModeAware() {
        if (this.modeAware == null) {
            N4JSOutlineModes _n4JSOutlineModes = new N4JSOutlineModes();
            this.modeAware = _n4JSOutlineModes;
        }
        return this.modeAware;
    }

    protected void createChildren_(IOutlineNode parentNode, EObject modelElement) {
        if (parentNode instanceof DocumentRootNode && modelElement != null) {
            this._createChildren_((DocumentRootNode)parentNode, modelElement);
            return;
        }
        if (parentNode != null && modelElement instanceof N4EnumDeclaration) {
            this._createChildren_(parentNode, (N4EnumDeclaration)modelElement);
            return;
        }
        if (parentNode != null && modelElement instanceof N4ClassifierDefinition) {
            this._createChildren_(parentNode, (N4ClassifierDefinition)modelElement);
            return;
        }
        if (parentNode != null && modelElement instanceof Script) {
            this._createChildren_(parentNode, (Script)modelElement);
            return;
        }
        if (parentNode != null && modelElement != null) {
            this._createChildren_(parentNode, modelElement);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(parentNode, modelElement).toString());
    }

    public boolean canCreateChildNode(Object it) {
        if (it instanceof N4ClassifierDefinition) {
            return this._canCreateChildNode((N4ClassifierDefinition)it);
        }
        if (it != null) {
            return this._canCreateChildNode(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    protected boolean isLeaf(EObject vd) {
        if (vd instanceof ExportedVariableDeclaration) {
            return this._isLeaf((ExportedVariableDeclaration)vd);
        }
        if (vd instanceof N4ClassifierDefinition) {
            return this._isLeaf((N4ClassifierDefinition)vd);
        }
        if (vd instanceof N4FieldDeclaration) {
            return this._isLeaf((N4FieldDeclaration)vd);
        }
        if (vd instanceof ImportDeclaration) {
            return this._isLeaf((ImportDeclaration)vd);
        }
        if (vd instanceof TMember) {
            return this._isLeaf((TMember)vd);
        }
        if (vd instanceof FunctionOrFieldAccessor) {
            return this._isLeaf((FunctionOrFieldAccessor)vd);
        }
        if (vd instanceof Script) {
            return this._isLeaf((Script)vd);
        }
        if (vd != null) {
            return this._isLeaf(vd);
        }
        if (vd == null) {
            return this._isLeaf((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(vd).toString());
    }
}

